/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;

public class WorldFeatureCrystalChunk
extends WorldFeature {
    private final boolean isCeiling;
    private final int minHeight;
    private final int heightMod;
    private final boolean decorateFloor;

    public WorldFeatureCrystalChunk(boolean isCeiling) {
        this.isCeiling = isCeiling;
        this.minHeight = 30;
        this.heightMod = 50;
        this.decorateFloor = false;
    }

    public WorldFeatureCrystalChunk(boolean isCeiling, int minHeight, int heightMod, boolean decorateFloor) {
        this.isCeiling = isCeiling;
        this.minHeight = minHeight;
        this.heightMod = heightMod;
        this.decorateFloor = decorateFloor;
    }

    @Override
    public boolean place(World world, Random random, int x, int y, int z) {
        int blockId;
        int x1 = x + random.nextInt(2) - random.nextInt(2);
        int z1 = z + random.nextInt(2) - random.nextInt(2);
        int yF = y;
        int checksForGround = 0;
        boolean canGenerate = false;
        while (true) {
            yF = this.isCeiling ? ++yF : --yF;
            if (checksForGround > 64 || yF < 0 || yF >= world.getHeightBlocks()) break;
            blockId = world.getBlockId(x1, yF, z1);
            if (Blocks.solid[blockId]) {
                canGenerate = true;
                break;
            }
            ++checksForGround;
        }
        blockId = world.getBlockId(x1, yF, z1);
        if (canGenerate && (blockId == Blocks.COBBLE_NETHERRACK.id() || blockId == Blocks.SOULSAND.id())) {
            yF = this.isCeiling ? (yF += 5) : (yF -= 5);
            this.placeCrystal(world, random, x1, yF, z1);
            return true;
        }
        return false;
    }

    private void placeCrystal(World world, Random random, int x, int y, int z) {
        int dz;
        int dx;
        float r = random.nextFloat();
        int length = this.minHeight + MathHelper.floor(Math.pow(r, 4.0) * (double)this.heightMod);
        int base = length / 4;
        float rx = 0.0f;
        float ry = 0.0f;
        float rz = 0.0f;
        int n = y = this.isCeiling ? y + base / 2 : y - base / 2;
        if (!this.hasSpace(world, x, y, z, base)) {
            return;
        }
        if (this.isCeiling) {
            rx = (float)Math.PI;
        }
        float rxSin = MathHelper.sin(rx += (float)((random.nextDouble() - 0.5) * 1.5707963267948966) * 0.8f);
        float rxCos = MathHelper.cos(rx);
        float rySin = MathHelper.sin(ry += (float)(random.nextDouble() * 2.0 * Math.PI));
        float ryCos = MathHelper.cos(ry);
        float rzSin = MathHelper.sin(rz);
        float rzCos = MathHelper.cos(rz);
        float[][] rxMatrix = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, rxCos, -rxSin}, {0.0f, rxSin, rxCos}};
        float[][] ryMatrix = new float[][]{{ryCos, 0.0f, rySin}, {0.0f, 1.0f, 0.0f}, {-rySin, 0.0f, ryCos}};
        float[][] rzMatrix = new float[][]{{rzCos, -rzSin, 0.0f}, {rzSin, rzCos, 0.0f}, {0.0f, 0.0f, 1.0f}};
        float[][] matrix = this.mult((float[][])ryMatrix, rxMatrix);
        int i = 0;
        for (int dy = 0; dy < length; ++dy) {
            for (dx = 0; dx < base; ++dx) {
                for (dz = 0; dz < base; ++dz) {
                    if (dy <= base + random.nextInt(4)) {
                        this.place(world, Blocks.NETHERRACK_CRYSTALLINE.id(), x, y, z, (float)(dx + i) + 0.5f, (float)dy + 0.5f, (float)(dz + i) + 0.5f, matrix);
                        continue;
                    }
                    this.place(world, Blocks.CRYSTAL.id(), x, y, z, (float)(dx + i) + 0.5f, (float)dy + 0.5f, (float)(dz + i) + 0.5f, matrix);
                }
            }
            if (!((double)random.nextFloat() > 0.95)) continue;
            ++i;
            if ((base -= 2) <= 1) break;
        }
        int yy = length;
        while (true) {
            ++i;
            if ((base -= 2) <= 0) break;
            for (dx = 0; dx < base; ++dx) {
                for (dz = 0; dz < base; ++dz) {
                    this.place(world, Blocks.CRYSTAL.id(), x, y, z, dx + i, yy, dz + i, matrix);
                }
            }
            ++yy;
        }
    }

    private float[][] mult(float[][] ma, float[][] mb) {
        float a = ma[0][0];
        float b = ma[0][1];
        float c = ma[0][2];
        float d = ma[1][0];
        float e = ma[1][1];
        float f = ma[1][2];
        float g = ma[2][0];
        float h = ma[2][1];
        float i = ma[2][2];
        float j = mb[0][0];
        float k = mb[0][1];
        float l = mb[0][2];
        float m = mb[1][0];
        float n = mb[1][1];
        float o = mb[1][2];
        float p = mb[2][0];
        float q = mb[2][1];
        float r = mb[2][2];
        return new float[][]{{a * j + b * m + c * p, a * k + b * n + c * q, a * l + b * o + c * r}, {d * j + e * m + f * p, d * k + e * n + f * q, d * l + e * o + f * r}, {g * j + h * m + i * p, g * k + h * n + i * q, g * l + h * o + i * r}};
    }

    private float[] mult(float[][] m, float[] v) {
        return new float[]{m[0][0] * v[0] + m[0][1] * v[1] + m[0][2] * v[2], m[1][0] * v[0] + m[1][1] * v[1] + m[1][2] * v[2], m[2][0] * v[0] + m[2][1] * v[1] + m[2][2] * v[2]};
    }

    private void place(World world, int id, int ox, int oy, int oz, float dx, float dy, float dz, float[][] m) {
        float[] v = new float[]{dx, dy, dz};
        float[] t = this.mult(m, v);
        int x = ox + MathHelper.floor(t[0]);
        int y = oy + MathHelper.floor(t[1]);
        int z = oz + MathHelper.floor(t[2]);
        world.setBlock(x, y, z, id);
        world.setBlock(x + 1, y, z, id);
        world.setBlock(x, y, z + 1, id);
        world.setBlock(x + 1, y, z + 1, id);
        world.setBlock(x, y + 1, z, id);
        world.setBlock(x + 1, y + 1, z, id);
        world.setBlock(x, y + 1, z + 1, id);
        world.setBlock(x + 1, y + 1, z + 1, id);
        world.markBlocksDirty(x, y, z, x + 1, y + 1, z + 1);
    }

    private boolean hasSpace(World world, int x, int y, int z, int base) {
        for (int yi = y; yi < y + base; ++yi) {
            for (int xi = x - base; xi < x + base; ++xi) {
                for (int zi = z - base; zi < z + base; ++zi) {
                    if (world.getBlockId(xi, yi, zi) != Blocks.CRYSTAL.id()) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

