/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.settings;

import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.save.WorldConfigurationReader;
import net.minecraft.core.world.settings.ListSettingNodeChildrenProvider;
import net.minecraft.core.world.settings.SettingNode;
import net.minecraft.core.world.settings.SettingNodeChildrenProvider;
import net.minecraft.core.world.settings.SettingNodeVisibilityListener;
import org.jetbrains.annotations.NotNull;

public class ContainerSettingNode
implements SettingNode {
    @NotNull
    private final SettingNodeChildrenProvider childrenProvider;
    @NotNull
    private SettingNodeVisibilityListener visibilityListener = SettingNodeVisibilityListener::alwaysVisible;

    public ContainerSettingNode(@NotNull SettingNodeChildrenProvider childrenProvider) {
        this.childrenProvider = childrenProvider;
    }

    @Override
    @NotNull
    public SettingNode withChild(@NotNull SettingNode child) {
        SettingNodeChildrenProvider settingNodeChildrenProvider = this.childrenProvider;
        if (!(settingNodeChildrenProvider instanceof ListSettingNodeChildrenProvider)) {
            throw new RuntimeException("Incorrect child provider to manually add child!");
        }
        @NotNull ListSettingNodeChildrenProvider childrenProvider = (ListSettingNodeChildrenProvider)settingNodeChildrenProvider;
        childrenProvider.withChild(child);
        return this;
    }

    @NotNull
    public final ContainerSettingNode withVisibilityListener(@NotNull SettingNodeVisibilityListener visibilityListener) {
        this.visibilityListener = visibilityListener;
        return this;
    }

    @Override
    @NotNull
    public SettingNodeChildrenProvider getChildrenProvider() {
        return this.childrenProvider;
    }

    @Override
    public boolean isVisible(@NotNull Dimension dimension, @NotNull WorldConfigurationReader config) {
        return this.visibilityListener.isVisible(config);
    }

    @Override
    public boolean areChildrenVisible(@NotNull Dimension dimension, @NotNull WorldConfigurationReader config) {
        return this.visibilityListener.isVisible(config);
    }
}

