/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGeneric;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicRotatable;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityFurnaceBlast;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericFurnace<T extends BlockLogic>
extends BlockModelGeneric<T> {
    public final StaticBlockModel filled;

    public BlockModelGenericFurnace(@NotNull Block<T> block, @NotNull String baseKey) {
        super(block, BlockModelDispatcher.loadDataModel(baseKey));
        this.filled = BlockModelDispatcher.loadDataModel(baseKey + "_filled").asModel();
    }

    @Override
    public boolean renderAttached(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos, boolean cullFaces, @Nullable IconCoordinate overrideTexture) {
        Direction direction = BlockLogicRotatable.getDirectionFromMeta(worldSource.getBlockData(tilePos));
        switch (direction) {
            case UP: {
                return this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 1, 2, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            }
            case DOWN: {
                return this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, -1, 2, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            }
            case NORTH: {
                return this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            }
            case WEST: {
                return this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 1, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            }
            case EAST: {
                return this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 3, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            }
            case SOUTH: {
                return this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 2, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            }
        }
        return this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 2, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
    }

    @Override
    @NotNull
    public StaticBlockModel getModel(@NotNull WorldSource source, @NotNull TilePosc tilePosc) {
        TileEntity tileEntity = source.getTileEntity(tilePosc);
        if (tileEntity instanceof Container) {
            boolean hasOutput;
            Container container = (Container)((Object)tileEntity);
            if (container instanceof TileEntityFurnaceBlast) {
                hasOutput = container.getItem(3) != null;
            } else {
                boolean bl = hasOutput = container.getItem(2) != null;
            }
            if (hasOutput) {
                return this.filled;
            }
        }
        return super.getModel(source, tilePosc);
    }
}

