/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.terrain;

import java.util.HashSet;
import java.util.List;
import net.minecraft.client.render.TileEntityRenderDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.culling.CameraFrustum;
import net.minecraft.client.render.terrain.ChunkRenderer;
import net.minecraft.client.render.terrain.RenderRegion;
import net.minecraft.client.render.terrain.TerrainRendererMultiDraw;
import net.minecraft.client.render.terrain.VertexBuffer;
import net.minecraft.client.render.tessellator.TessellatorTerrainImpl;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.ChunkCache;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkRendererMultiDraw
extends ChunkRenderer {
    @NotNull
    private static final TessellatorTerrainImpl TESSELLATOR = new TessellatorTerrainImpl(0x200000);
    public final @Nullable VertexBuffer.Entry<TessellatorTerrainImpl.TerrainVertexConfig> @NotNull [] renderListEntries;
    @NotNull
    private final TerrainRendererMultiDraw terrainRenderer;
    @NotNull
    private final TilePos min = new TilePos();
    @NotNull
    private final TilePos max = new TilePos();
    @NotNull
    private final TilePos cacheMin = new TilePos();
    @NotNull
    private final TilePos cacheMax = new TilePos();

    public ChunkRendererMultiDraw(@NotNull TerrainRendererMultiDraw terrainRenderer, @NotNull World world, @NotNull @NotNull List<@NotNull TileEntity> globalRenderableTileEntities, int x, int y, int z, int size) {
        super(world, globalRenderableTileEntities, x, y, z, size);
        this.terrainRenderer = terrainRenderer;
        this.renderListEntries = new VertexBuffer.Entry[2];
    }

    @Override
    public boolean rebuild(boolean priority) {
        if (!this.isDirty()) {
            return false;
        }
        this.min.set(this.pos);
        this.max.set(this.pos).add(this.size);
        boolean cacheRadius = true;
        this.cacheMin.set(this.min).sub(1, 1, 1);
        this.cacheMax.set(this.max).add(1, 1, 1);
        int renderPassCount = 2;
        ChunkCache chunkCache = new ChunkCache(this.getWorld(), this.cacheMin, this.cacheMax, priority);
        if (!chunkCache.allLoaded()) {
            return false;
        }
        this.terrainRenderer.chunkDeleted(this);
        Chunk.isLit = false;
        HashSet lastSpecialTileEntities = new HashSet(this.renderableBlockEntities);
        this.renderableBlockEntities.clear();
        ++updates;
        @NotNull TilePos pos = new TilePos(0, 0, 0);
        for (int renderPass = 0; renderPass < 2; ++renderPass) {
            boolean needsMoreRenderPasses = false;
            boolean hasRenderedBlock = false;
            boolean hasStartedDrawing = false;
            pos.y = this.min.y;
            while (pos.y < this.max.y) {
                pos.z = this.min.z;
                while (pos.z < this.max.z) {
                    pos.x = this.min.x;
                    while (pos.x < this.max.x) {
                        BlockModel model;
                        int blockRenderPass;
                        TileEntity tileentity;
                        @NotNull Block<?> block = chunkCache.getBlockType(pos);
                        if (!hasStartedDrawing) {
                            hasStartedDrawing = true;
                            TESSELLATOR.startDrawingQuads();
                            RenderRegion<TessellatorTerrainImpl.TerrainVertexConfig> region = this.terrainRenderer.getRenderRegionAtBlockPos(this.pos.x, this.pos.z);
                            TESSELLATOR.setTranslation(-(region.posX << 9), 0.0, -(region.posZ << 9));
                        }
                        if (renderPass == 0 && block.isEntityTile() && (tileentity = chunkCache.getTileEntity(pos)) != null && TileEntityRenderDispatcher.instance.hasRenderer(tileentity)) {
                            this.renderableBlockEntities.add(tileentity);
                        }
                        if ((blockRenderPass = (model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(block)).renderLayer()) != renderPass) {
                            needsMoreRenderPasses = true;
                        } else {
                            hasRenderedBlock |= this.renderBlock(chunkCache, model, pos);
                        }
                        ++pos.x;
                    }
                    ++pos.z;
                }
                ++pos.y;
            }
            if (hasStartedDrawing) {
                this.terrainRenderer.chunkRendered(this, TESSELLATOR, renderPass);
                TESSELLATOR.setTranslation(0.0, 0.0, 0.0);
            } else {
                hasRenderedBlock = false;
            }
            if (hasRenderedBlock) {
                this.empty[renderPass] = false;
            }
            if (!needsMoreRenderPasses) break;
        }
        HashSet newSpecialTileEntities = new HashSet(this.renderableBlockEntities);
        newSpecialTileEntities.removeAll(lastSpecialTileEntities);
        this.globalRenderableBlockEntities.addAll(newSpecialTileEntities);
        this.renderableBlockEntities.forEach(lastSpecialTileEntities::remove);
        this.globalRenderableBlockEntities.removeAll(lastSpecialTileEntities);
        this.compiled = true;
        return true;
    }

    @Override
    public void cull(@NotNull CameraFrustum frustum, float partialTick) {
        boolean wasVisible = this.visible;
        super.cull(frustum, partialTick);
        if (wasVisible != this.visible) {
            this.terrainRenderer.chunkVisibilityChanged(this);
        }
    }

    @Override
    public void reset() {
        this.terrainRenderer.chunkDeleted(this);
        super.reset();
    }

    public String toString() {
        return "[" + this.pos.x + "," + this.pos.y + "," + this.pos.z + "]";
    }

    protected boolean renderBlock(@NotNull WorldSource worldSource, @NotNull BlockModel<?> model, @NotNull TilePos tilePos) {
        TESSELLATOR.setLightmapCoord2i(15, 15);
        TESSELLATOR.setColor4i(255, 255, 255, 255);
        TESSELLATOR.setTextureUV(0.0, 0.0);
        TESSELLATOR.setShade1i(255);
        return model.render(TESSELLATOR, worldSource, tilePos);
    }
}

