/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.world.chunk.provider;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.world.ProgressListener;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.ChunkLoader;
import net.minecraft.core.world.chunk.EmptyChunk;
import net.minecraft.core.world.chunk.provider.ChunkProvider;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.pos.ChunkPos;
import net.minecraft.core.world.pos.ChunkPosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ChunkProviderDynamic
implements ChunkProvider {
    public static final int CHUNK_RADIUS = 32;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Set<ChunkPos> droppedChunksSet = new HashSet<ChunkPos>();
    private final Chunk emptyChunk;
    @Nullable
    public ChunkGenerator chunkGenerator;
    @Nullable
    private final ChunkLoader chunkLoader;
    @NotNull
    private final @NotNull Map<@NotNull ChunkPos, @NotNull Chunk> chunkMap = new HashMap<ChunkPos, Chunk>();
    @NotNull
    private final @NotNull Map<@NotNull ChunkPos, @NotNull Chunk> forceLoadedChunkMap;
    @NotNull
    private final List<Chunk> forceLoadedChunkList = new ArrayList<Chunk>();
    @NotNull
    private final World world;
    private int currentChunkX;
    private int currentChunkZ;
    public int forceLoadedChunksLimit = 64;
    public int maxUnloadPerTick = 10;
    private int lastQueriedChunkXPos;
    private int lastQueriedChunkZPos;
    private Chunk lastQueriedChunk;

    public ChunkProviderDynamic(@NotNull World world, @Nullable ChunkLoader chunkLoader, @Nullable ChunkGenerator chunkGenerator) {
        this.forceLoadedChunkMap = new HashMap<ChunkPos, Chunk>();
        this.emptyChunk = new EmptyChunk(world, 0, 0);
        this.world = world;
        this.chunkLoader = chunkLoader;
        this.chunkGenerator = chunkGenerator;
    }

    @Override
    public boolean isChunkLoaded(@NotNull ChunkPosc chunkPos) {
        if (this.canChunkBeUnloaded(chunkPos)) {
            if (this.chunkMap.containsKey(chunkPos)) {
                this.droppedChunksSet.add(new ChunkPos(chunkPos));
            }
            return false;
        }
        Chunk chunk = this.chunkMap.get(chunkPos);
        return chunk == this.emptyChunk || chunk != null && chunk.isAtLocation(chunkPos);
    }

    public boolean canChunkBeUnloaded(@NotNull ChunkPosc chunkPos) {
        if (this.forceLoadedChunkMap.containsKey(chunkPos)) {
            return false;
        }
        int renderDistance = 31;
        return chunkPos.x() < this.currentChunkX - renderDistance || chunkPos.z() < this.currentChunkZ - renderDistance || chunkPos.x() > this.currentChunkX + renderDistance || chunkPos.z() > this.currentChunkZ + renderDistance;
    }

    @Override
    @NotNull
    public Chunk provideChunk(@NotNull ChunkPosc chunkPos, boolean priority) {
        if (chunkPos.x() == this.lastQueriedChunkXPos && chunkPos.z() == this.lastQueriedChunkZPos && this.lastQueriedChunk != null) {
            return this.lastQueriedChunk;
        }
        if (!this.world.findingSpawnPoint && this.canChunkBeUnloaded(chunkPos)) {
            return this.emptyChunk;
        }
        if (!this.isChunkLoaded(chunkPos.x(), chunkPos.z())) {
            Chunk chunk;
            if (this.chunkMap.get(chunkPos) != null) {
                chunk = this.chunkMap.get(chunkPos);
                this.saveChunk(chunk);
                chunk.onUnload();
            }
            if ((chunk = this.loadChunk(chunkPos.x(), chunkPos.z())) == null) {
                if (this.chunkGenerator != null) {
                    chunk = this.chunkGenerator.generate(chunkPos.x(), chunkPos.z());
                    chunk.fixMissingBlocks();
                } else {
                    chunk = this.emptyChunk;
                }
            }
            this.chunkMap.put(new ChunkPos(chunkPos), chunk);
            chunk.checkForLightGaps();
            chunk.onLoad();
            @NotNull ChunkPos queryPos = new ChunkPos(chunkPos);
            if (!chunk.isTerrainPopulated && this.isChunkLoaded(chunkPos.add(1, 1, queryPos)) && this.isChunkLoaded(chunkPos.add(0, 1, queryPos)) && this.isChunkLoaded(chunkPos.add(1, 0, queryPos))) {
                this.populate(chunkPos);
            }
            if (this.isChunkLoaded(chunkPos.add(-1, 0, queryPos)) && !this.provideChunk((ChunkPosc)chunkPos.add((int)-1, (int)0, (ChunkPos)queryPos), (boolean)true).isTerrainPopulated && this.isChunkLoaded(chunkPos.add(-1, 1, queryPos)) && this.isChunkLoaded(chunkPos.add(0, 1, queryPos))) {
                this.populate(chunkPos.add(-1, 0, queryPos));
            }
            if (this.isChunkLoaded(chunkPos.add(0, -1, queryPos)) && !this.provideChunk((ChunkPosc)chunkPos.add((int)0, (int)-1, (ChunkPos)queryPos), (boolean)true).isTerrainPopulated && this.isChunkLoaded(chunkPos.add(1, -1, queryPos)) && this.isChunkLoaded(chunkPos.add(1, 0, queryPos))) {
                this.populate(chunkPos.add(0, -1, queryPos));
            }
            if (this.isChunkLoaded(chunkPos.add(-1, -1, queryPos)) && !this.provideChunk((ChunkPosc)chunkPos.add((int)-1, (int)-1, (ChunkPos)queryPos), (boolean)true).isTerrainPopulated && this.isChunkLoaded(chunkPos.add(0, -1, queryPos)) && this.isChunkLoaded(chunkPos.add(-1, 0, queryPos))) {
                this.populate(chunkPos.add(-1, -1, queryPos));
            }
            if (this.world.getCurrentWeather() != null) {
                this.world.getCurrentWeather().doChunkLoadEffect(this.world, chunk);
            }
        }
        this.lastQueriedChunkXPos = chunkPos.x();
        this.lastQueriedChunkZPos = chunkPos.z();
        this.lastQueriedChunk = this.chunkMap.get(chunkPos);
        return this.chunkMap.get(chunkPos);
    }

    @Override
    @NotNull
    public Chunk prepareChunk(@NotNull ChunkPosc chunkPos, boolean priority) {
        return this.provideChunk(chunkPos, true);
    }

    @Override
    public void regenerateChunk(@NotNull ChunkPosc chunkPos) {
        this.droppedChunksSet.remove(chunkPos);
        this.chunkMap.remove(chunkPos);
        if (this.chunkGenerator == null) {
            return;
        }
        Chunk chunk = this.chunkGenerator.generate(chunkPos.x(), chunkPos.z());
        chunk.fixMissingBlocks();
        this.chunkMap.put(new ChunkPos(chunkPos), chunk);
        @NotNull ChunkPos queryPos = new ChunkPos(chunkPos);
        if (!chunk.isTerrainPopulated && this.isChunkLoaded(chunkPos.add(1, 1, queryPos)) && this.isChunkLoaded(chunkPos.add(0, 1, queryPos)) && this.isChunkLoaded(chunkPos.add(1, 0, queryPos))) {
            this.populate(chunkPos);
        }
        if (this.isChunkLoaded(chunkPos.add(-1, 0, queryPos)) && !this.provideChunk((ChunkPosc)chunkPos.add((int)-1, (int)0, (ChunkPos)queryPos), (boolean)true).isTerrainPopulated && this.isChunkLoaded(chunkPos.add(-1, 1, queryPos)) && this.isChunkLoaded(chunkPos.add(0, 1, queryPos))) {
            this.populate(chunkPos.add(-1, 0, queryPos));
        }
        if (this.isChunkLoaded(chunkPos.add(0, -1, queryPos)) && !this.provideChunk((ChunkPosc)chunkPos.add((int)0, (int)-1, (ChunkPos)queryPos), (boolean)true).isTerrainPopulated && this.isChunkLoaded(chunkPos.add(1, -1, queryPos)) && this.isChunkLoaded(chunkPos.add(1, 0, queryPos))) {
            this.populate(chunkPos.add(0, -1, queryPos));
        }
        if (this.isChunkLoaded(chunkPos.add(-1, -1, queryPos)) && !this.provideChunk((ChunkPosc)chunkPos.add((int)-1, (int)-1, (ChunkPos)queryPos), (boolean)true).isTerrainPopulated && this.isChunkLoaded(chunkPos.add(0, -1, queryPos)) && this.isChunkLoaded(chunkPos.add(-1, 0, queryPos))) {
            this.populate(chunkPos.add(-1, -1, queryPos));
        }
    }

    @Override
    public void populate(@NotNull ChunkPosc chunkPos) {
        Chunk chunk = this.provideChunk(chunkPos, true);
        if (!chunk.isTerrainPopulated) {
            chunk.isTerrainPopulated = true;
            if (this.chunkGenerator != null) {
                this.chunkGenerator.decorate(chunk);
                chunk.setChunkModified();
            }
        }
    }

    public boolean keepLoaded(@NotNull ChunkPos chunkPos) {
        Chunk chunk = this.chunkMap.get(chunkPos);
        if (!this.forceLoadedChunkMap.containsKey(chunkPos) && this.forceLoadedChunkList.size() < this.forceLoadedChunksLimit) {
            this.forceLoadedChunkMap.put(new ChunkPos(chunkPos), chunk);
            this.forceLoadedChunkList.add(chunk);
            return true;
        }
        return false;
    }

    public boolean removeFromForceLoaded(@NotNull ChunkPos chunkPos) {
        this.forceLoadedChunkList.remove(this.forceLoadedChunkMap.get(chunkPos));
        return this.forceLoadedChunkMap.remove(chunkPos) != null;
    }

    @Override
    public boolean saveChunks(boolean saveImmediately, @Nullable ProgressListener progressListener) {
        int attempts = 0;
        int chunksToBeSaved = 0;
        if (progressListener != null) {
            for (Chunk chunk : this.chunkMap.values()) {
                if (!chunk.needsSaving(saveImmediately)) continue;
                ++chunksToBeSaved;
            }
        }
        int progress = 0;
        for (Chunk chunk : this.chunkMap.values()) {
            if (!chunk.needsSaving(saveImmediately)) continue;
            this.saveChunk(chunk);
            chunk.isModified = false;
            if (++attempts == 2 && !saveImmediately) {
                return false;
            }
            if (progressListener == null || ++progress % 10 != 0) continue;
            progressListener.progressStagePercentage(progress * 100 / chunksToBeSaved);
        }
        return true;
    }

    private void saveChunk(Chunk chunk) {
        if (this.chunkLoader == null) {
            return;
        }
        try {
            chunk.lastSaveTime = this.world.getWorldTime();
            this.chunkLoader.saveChunk(this.world, chunk);
        }
        catch (IOException ioexception) {
            LOGGER.error("Failed to save chunk at {}, {}!", chunk.pos.x, chunk.pos.z, ioexception);
        }
    }

    private Chunk loadChunk(int x, int y) {
        if (this.chunkLoader == null) {
            return this.emptyChunk;
        }
        try {
            Chunk chunk = this.chunkLoader.loadChunk(this.world, x, y);
            if (chunk != null) {
                chunk.lastSaveTime = this.world.getWorldTime();
            }
            return chunk;
        }
        catch (Exception exception) {
            LOGGER.error("Failed to load chunk at {}, {}!", x, y, exception);
            return this.emptyChunk;
        }
    }

    @Override
    public boolean tick() {
        int dropped = 0;
        for (Chunk chunk : this.chunkMap.values()) {
            if (dropped >= this.maxUnloadPerTick) break;
            this.isChunkLoaded(chunk.pos);
        }
        if (!this.droppedChunksSet.isEmpty()) {
            int unloaded = 0;
            HashSet<ChunkPos> copy = new HashSet<ChunkPos>(this.droppedChunksSet);
            for (ChunkPos pos : copy) {
                if (unloaded >= this.maxUnloadPerTick) break;
                if (this.forceLoadedChunkMap.containsKey(pos)) continue;
                if (this.chunkMap.containsKey(pos)) {
                    Chunk chunk = this.chunkMap.get(pos);
                    chunk.onUnload();
                    this.saveChunk(chunk);
                    this.chunkMap.remove(pos);
                    this.droppedChunksSet.remove(pos);
                    ++unloaded;
                    continue;
                }
                this.droppedChunksSet.remove(pos);
            }
        }
        return false;
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Nullable
    public ChunkLoader getChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    @NotNull
    public String getInfoString() {
        return "Chunks: " + this.chunkMap.size() + ", Dropped: " + this.droppedChunksSet.size() + ", Chunkloaded: " + this.forceLoadedChunkMap.size() + "/" + this.forceLoadedChunksLimit;
    }

    public List<Chunk> getForceLoadedChunks() {
        return Collections.unmodifiableList(this.forceLoadedChunkList);
    }

    @Override
    public void unloadAllChunks() {
        for (Chunk chunk : this.chunkMap.values()) {
            chunk.onUnload();
        }
        this.chunkMap.clear();
        this.droppedChunksSet.clear();
        this.forceLoadedChunkMap.clear();
        this.forceLoadedChunkList.clear();
        this.chunkGenerator = null;
        System.gc();
    }

    @Override
    public void setCurrentChunkOver(@NotNull ChunkPosc chunkPos) {
        this.currentChunkX = chunkPos.x();
        this.currentChunkZ = chunkPos.z();
    }
}

