/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.gamemode;

import java.util.function.Function;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuInventory;
import org.jetbrains.annotations.NotNull;

public class GamemodeBuilder {
    @NotNull
    private final String languageKey;
    @NotNull
    private final @NotNull Function<@NotNull ContainerInventory, @NotNull MenuInventory> inventoryMenuSupplier;
    private boolean invulnerablePlayer = false;
    private boolean playerFlight = false;
    private boolean blockConsumption = false;
    private boolean blockBreakingAnimation = false;
    private boolean toolDurability = false;
    private boolean itemDrops = false;
    private boolean hostileMobs = false;
    private boolean fireImmunity = false;
    private boolean instantPortalTravel = false;
    private boolean properToolNeededToMine = false;
    private boolean canInteract = true;
    private boolean permaDeath = false;
    private float blockReachDistance = 4.5f;
    private float entityReachDistance = 3.0f;

    public GamemodeBuilder(@NotNull String languageKey, @NotNull @NotNull Function<@NotNull ContainerInventory, @NotNull MenuInventory> inventoryMenuSupplier) {
        this.languageKey = languageKey;
        this.inventoryMenuSupplier = inventoryMenuSupplier;
    }

    @NotNull
    public Gamemode build() {
        return new Gamemode(this.languageKey, this.inventoryMenuSupplier, this.invulnerablePlayer, this.playerFlight, this.blockConsumption, this.blockBreakingAnimation, this.toolDurability, this.itemDrops, this.hostileMobs, this.fireImmunity, this.instantPortalTravel, this.properToolNeededToMine, this.canInteract, this.permaDeath, this.blockReachDistance, this.entityReachDistance);
    }

    @NotNull
    public GamemodeBuilder withInvulnerablePlayer() {
        this.invulnerablePlayer = true;
        return this;
    }

    @NotNull
    public GamemodeBuilder withPlayerFlight() {
        this.playerFlight = true;
        return this;
    }

    @NotNull
    public GamemodeBuilder withBlockConsumption() {
        this.blockConsumption = true;
        return this;
    }

    @NotNull
    public GamemodeBuilder withBlockBreakingAnimation() {
        this.blockBreakingAnimation = true;
        return this;
    }

    @NotNull
    public GamemodeBuilder withToolDurability() {
        this.toolDurability = true;
        return this;
    }

    @NotNull
    public GamemodeBuilder withItemDrops() {
        this.itemDrops = true;
        return this;
    }

    @NotNull
    public GamemodeBuilder withHostileMobs() {
        this.hostileMobs = true;
        return this;
    }

    @NotNull
    public GamemodeBuilder withFireImmunity() {
        this.fireImmunity = true;
        return this;
    }

    @NotNull
    public GamemodeBuilder withInstantPortalTravel() {
        this.instantPortalTravel = true;
        return this;
    }

    @NotNull
    public GamemodeBuilder withBlockReachDistance(float blockReachDistance) {
        this.blockReachDistance = blockReachDistance;
        return this;
    }

    @NotNull
    public GamemodeBuilder withEntityReachDistance(float entityReachDistance) {
        this.entityReachDistance = entityReachDistance;
        return this;
    }

    @NotNull
    public GamemodeBuilder withProperToolNeededToMine() {
        this.properToolNeededToMine = true;
        return this;
    }

    @NotNull
    public GamemodeBuilder withNoInteraction() {
        this.canInteract = false;
        return this;
    }

    @NotNull
    public GamemodeBuilder withPermaDeath() {
        this.permaDeath = true;
        return this;
    }
}

