/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.player.controller;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.controller.PlayerController;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerControllerSP
extends PlayerController {
    public PlayerControllerSP(@NotNull Minecraft minecraft) {
        super(minecraft);
    }

    @Override
    public boolean destroyBlock(@NotNull TilePosc tilePos, @NotNull Side side) {
        @NotNull World world = Objects.requireNonNull(this.mc.currentWorld);
        @NotNull Player player = Objects.requireNonNull(this.mc.thePlayer);
        if (!player.getGamemode().canInteract() || player.getHeldObject() != null) {
            return false;
        }
        @NotNull Block<?> block = world.getBlockType(tilePos);
        int data = world.getBlockData(tilePos);
        @Nullable TileEntity tileEntity = world.getTileEntity(tilePos);
        boolean removed = super.destroyBlock(tilePos, side);
        @Nullable ItemStack item = player.getCurrentEquippedItem();
        if (item != null) {
            item.onBlockDestroyed(world, player, block, tilePos, side);
        }
        if (removed && player.getGamemode().hasItemDrops()) {
            block.onHarvest(world, player, tilePos, data, tileEntity);
        }
        if (item != null && item.stackSize <= 0) {
            player.destroyCurrentEquippedItem();
        }
        return removed;
    }
}

