/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory.container;

import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerCrafting
implements Container {
    @NotNull
    private final MenuAbstract menu;
    private final int xSize;
    private final @Nullable ItemStack @NotNull [] items;

    public ContainerCrafting(@NotNull MenuAbstract menu, int xSize, int ySize) {
        this.menu = menu;
        this.xSize = xSize;
        this.items = new ItemStack[xSize * ySize];
    }

    @Override
    public int getContainerSize() {
        return this.items.length;
    }

    @Override
    @Nullable
    public ItemStack getItem(int slot) {
        if (slot >= this.getContainerSize()) {
            return null;
        }
        return this.items[slot];
    }

    @Nullable
    public ItemStack getItemStackAt(int x, int y) {
        if (x < 0 || x >= this.xSize) {
            return null;
        }
        return this.getItem(x + y * this.xSize);
    }

    public void setSlotContentsAt(int x, int y, @Nullable ItemStack stack) {
        if (x >= 0 && x < this.xSize) {
            this.setItem(x + y * this.xSize, stack);
        }
    }

    @Override
    @NotNull
    public String getNameTranslationKey() {
        return "container.crafting.name";
    }

    @Override
    @Nullable
    public ItemStack removeItem(int slot, int takeAmount) {
        @Nullable ItemStack currentItem = this.items[slot];
        if (currentItem != null) {
            if (currentItem.stackSize <= takeAmount) {
                this.items[slot] = null;
                this.menu.slotsChanged(this);
                return currentItem;
            }
            @NotNull ItemStack otherHalf = currentItem.splitStack(takeAmount);
            if (currentItem.stackSize <= 0) {
                this.items[slot] = null;
            }
            this.menu.slotsChanged(this);
            return otherHalf;
        }
        return null;
    }

    @Override
    public void setItem(int slot, @Nullable ItemStack stack) {
        this.items[slot] = stack;
        this.menu.slotsChanged(this);
    }

    @Override
    public int getMaxStackSize() {
        return 64;
    }

    @Override
    public void setChanged() {
        this.menu.slotsChanged(this);
    }

    @Override
    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    @Override
    public void sort() {
    }
}

