/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory.menu;

import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.HumanArmorShape;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.container.ContainerCrafting;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.container.ContainerResult;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.player.inventory.slot.SlotArmor;
import net.minecraft.core.player.inventory.slot.SlotResult;
import org.jetbrains.annotations.NotNull;

public class MenuInventory
extends MenuAbstract {
    private static final int NUM_CRAFTING_COLUMNS = 2;
    private static final int NUM_CRAFTING_ROWS = 2;
    private static final int NUM_RESULT_SLOTS = 1;
    private static final int RESULT_SLOTS_START = 0;
    private static final int CRAFTING_SLOTS_START = 1;
    private static final int ARMOR_SLOTS_START = 5;
    private static final int INVENTORY_SLOTS_START = 5 + ContainerInventory.ARMOR_INVENTORY_SIZE;
    private static final int HOTBAR_SLOTS_START = INVENTORY_SLOTS_START + 27;
    public ContainerCrafting craftSlots;
    public Container resultSlots;
    public ContainerInventory inventory;

    public MenuInventory(ContainerInventory inventory) {
        int i;
        int x;
        int y;
        this.inventory = inventory;
        this.craftSlots = new ContainerCrafting(this, 2, 2);
        this.resultSlots = new ContainerResult();
        this.addSlot(new SlotResult(inventory.player, this.craftSlots, this.resultSlots, 0, 144, 36));
        for (y = 0; y < 2; ++y) {
            for (x = 0; x < 2; ++x) {
                this.addSlot(new Slot(this.craftSlots, x + y * 2, 88 + x * 18, 26 + y * 18));
            }
        }
        for (i = 0; i < ContainerInventory.ARMOR_INVENTORY_SIZE; ++i) {
            this.addSlot(new SlotArmor(this, inventory, 36 + i, 8, 8 + i * 18, HumanArmorShape.values()[ContainerInventory.ARMOR_INVENTORY_SIZE - (i + 1)]));
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.addSlot(new Slot(inventory, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot(inventory, i, 8 + i * 18, 142));
        }
        this.slotsChanged(this.craftSlots);
    }

    @Override
    public void slotsChanged(Container iinventory) {
        this.resultSlots.setItem(0, Registries.RECIPES.findMatchingRecipe(this.craftSlots));
    }

    @Override
    public void onCraftGuiClosed(@NotNull Player player) {
        super.onCraftGuiClosed(player);
        boolean insert = false;
        for (int i = 0; i < 4; ++i) {
            ItemStack itemstack = this.craftSlots.getItem(i);
            if (itemstack == null) continue;
            this.craftSlots.setItem(i, null);
            this.storeOrDropItem(player, itemstack);
            insert = true;
        }
        if (insert) {
            player.world.playSoundAtEntity(null, player, "random.insert", 0.1f, 1.0f);
        }
    }

    @Override
    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    @Override
    public IntList getMoveSlots(@NotNull InventoryAction action, @NotNull Slot slot, int target, Player player) {
        if (slot.index >= 0 && slot.index < 1) {
            return this.getSlots(0, 1, false);
        }
        if (slot.index >= 1 && slot.index < 5) {
            return this.getSlots(1, 4, false);
        }
        if (slot.index >= 5 && slot.index < INVENTORY_SLOTS_START) {
            return this.getSlots(5, ContainerInventory.ARMOR_INVENTORY_SIZE, false);
        }
        if (action == InventoryAction.MOVE_SIMILAR) {
            if (slot.index >= INVENTORY_SLOTS_START && slot.index < HOTBAR_SLOTS_START + 9) {
                return this.getSlots(INVENTORY_SLOTS_START, 36, false);
            }
        } else {
            if (slot.index >= INVENTORY_SLOTS_START && slot.index < HOTBAR_SLOTS_START) {
                return this.getSlots(INVENTORY_SLOTS_START, 27, false);
            }
            if (slot.index >= HOTBAR_SLOTS_START && slot.index < HOTBAR_SLOTS_START + 9) {
                return this.getSlots(HOTBAR_SLOTS_START, 9, false);
            }
        }
        return null;
    }

    @Override
    public IntList getTargetSlots(@NotNull InventoryAction action, @NotNull Slot slot, int target, Player player) {
        if (slot.index >= INVENTORY_SLOTS_START && slot.index < HOTBAR_SLOTS_START + 9) {
            if (target == 1) {
                return this.getSlots(1, 4, false);
            }
            if (target == 2) {
                return this.getSlots(5, ContainerInventory.ARMOR_INVENTORY_SIZE, false);
            }
            if (slot.index < HOTBAR_SLOTS_START) {
                return this.getSlots(HOTBAR_SLOTS_START, 9, false);
            }
            return this.getSlots(INVENTORY_SLOTS_START, 27, false);
        }
        if (slot.index == 0) {
            return this.getSlots(INVENTORY_SLOTS_START, 36, true);
        }
        return this.getSlots(INVENTORY_SLOTS_START, 36, false);
    }
}

