/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.noise.operator;

import net.minecraft.core.world.noise.Noise3D;
import net.minecraft.core.world.noise.operator.Normalize2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2dc;

public class Normalize3D<T extends Noise3D>
extends Normalize2D<T>
implements Noise3D {
    public Normalize3D(@NotNull T noise) {
        super(noise);
    }

    @Override
    @NotNull
    public Vector2dc getRange3D() {
        return this.getRange2D();
    }

    @Override
    public double getValue(double x, double y, double z) {
        @NotNull Vector2dc range = ((Noise3D)this.noise).getRange2D();
        double r = range.y() - range.x();
        double v = ((Noise3D)this.noise).getValue(x, y, z);
        double vo = v - range.x();
        return vo / r;
    }

    @Override
    public double @NotNull [] addRegion(double @Nullable [] out, double x, double y, double z, int xSize, int ySize, int zSize, double xScale, double yScale, double zScale, double amplitude) {
        if (out == null || out.length < xSize * zSize) {
            out = new double[xSize * zSize];
        }
        @NotNull Vector2dc range = ((Noise3D)this.noise).getRange2D();
        double r = range.y() - range.x();
        double @NotNull [] temp = ((Noise3D)this.noise).addRegion(null, x, y, z, xSize, ySize, zSize, xScale, yScale, zScale, amplitude);
        for (int i = 0; i < out.length; ++i) {
            temp[i] = (temp[i] - range.x()) / r;
            int n = i;
            out[n] = out[n] + temp[i];
        }
        return out;
    }
}

