/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.server;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.NbtIo;
import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import com.mojang.nbt.tags.LongTag;
import com.mojang.nbt.tags.StringTag;
import com.mojang.nbt.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.gui.server.ScreenSelectServer;
import net.minecraft.client.gui.server.ServerEntry;
import net.minecraft.core.Global;
import net.minecraft.core.net.ServerAddress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ServerManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    public Lock idToEntryLock = new ReentrantLock();
    @NotNull
    public final Map<UUID, ServerEntry> idToEntryMap = new HashMap<UUID, ServerEntry>();
    @NotNull
    private final Map<UUID, ServerEntry> favoritesMap = new HashMap<UUID, ServerEntry>();
    @NotNull
    private final List<ServerEntry> favorites = new ArrayList<ServerEntry>();
    @NotNull
    private final Map<UUID, ServerEntry> internetMap = new HashMap<UUID, ServerEntry>();
    @NotNull
    private final List<ServerEntry> internet = new ArrayList<ServerEntry>();
    @NotNull
    private final Map<UUID, ServerEntry> historyMap = new HashMap<UUID, ServerEntry>();
    @NotNull
    private final List<ServerEntry> history = new ArrayList<ServerEntry>();
    @NotNull
    private final Map<UUID, ServerEntry> lanMap = new HashMap<UUID, ServerEntry>();
    @NotNull
    private final Map<ServerAddress, ServerEntry> lanAddressMap = new HashMap<ServerAddress, ServerEntry>();
    @NotNull
    private final List<ServerEntry> lan = new ArrayList<ServerEntry>();
    @NotNull
    private final ScreenSelectServer attachedScreen;

    @NotNull
    public static ServerManager getServerManager(@NotNull ScreenSelectServer attachedScreen) {
        File file = new File(String.valueOf(Global.accessor.getMinecraftDir()) + "/servers_new.dat");
        try {
            return new ServerManager(attachedScreen, NbtIo.readCompressed(Files.newInputStream(file.toPath(), new OpenOption[0])));
        }
        catch (IOException e) {
            LOGGER.error("", e);
            return new ServerManager(attachedScreen, new CompoundTag());
        }
    }

    public static void saveServerManager(@NotNull ServerManager savedServerData) {
        File file = new File(String.valueOf(Global.accessor.getMinecraftDir()) + "/servers_new.dat");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                LOGGER.error("", e);
                return;
            }
        }
        try {
            NbtIo.writeCompressed(savedServerData.toTag(), Files.newOutputStream(file.toPath(), new OpenOption[0]));
        }
        catch (IOException e) {
            LOGGER.error("", e);
        }
    }

    private ServerManager(@NotNull ScreenSelectServer attachedScreen, @NotNull CompoundTag compoundTag) {
        ServerEntry entry;
        UUID uuid;
        Tag entryTag;
        this.attachedScreen = attachedScreen;
        CompoundTag entries = compoundTag.getCompound("ServerData");
        for (Map.Entry entry2 : ((Map)entries.getValue()).entrySet()) {
            UUID uuid2 = UUID.fromString((String)entry2.getKey());
            entryTag = (CompoundTag)entry2.getValue();
            ServerEntry entry22 = new ServerEntry(uuid2, ((CompoundTag)entryTag).getString("Address"));
            entry22.overrideName = ((CompoundTag)entryTag).getStringOrDefault("OverrideName", null);
            entry22.baseName = ((CompoundTag)entryTag).getStringOrDefault("BaseName", null);
            entry22.showIp = ((CompoundTag)entryTag).getBooleanOrDefault("ShowIp", false);
            entry22.dirty = true;
            entry22.requestIcon = true;
            this.addEntry(entry22);
        }
        ListTag favorites = compoundTag.getList("Favorites");
        for (Tag<?> tag : favorites) {
            entryTag = (StringTag)tag;
            uuid = UUID.fromString((String)entryTag.getValue());
            if (!this.idToEntryMap.containsKey(uuid)) continue;
            entry = this.idToEntryMap.get(uuid);
            this.addFavorite(entry);
        }
        CompoundTag compoundTag2 = compoundTag.getCompound("History");
        for (Map.Entry e : ((Map)compoundTag2.getValue()).entrySet()) {
            uuid = UUID.fromString((String)e.getKey());
            if (!this.idToEntryMap.containsKey(uuid)) continue;
            entry = this.idToEntryMap.get(uuid);
            entry.lastPlayedTime = (Long)((LongTag)e.getValue()).getValue();
            if (this.historyMap.containsKey(entry.uuid)) continue;
            this.historyMap.put(entry.uuid, entry);
            this.history.add(entry);
        }
        this.history.sort((o1, o2) -> Long.compare(o2.lastPlayedTime, o1.lastPlayedTime));
    }

    @NotNull
    private CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        HashSet<ServerEntry> entriesToSave = new HashSet<ServerEntry>();
        ListTag favorites = new ListTag();
        for (ServerEntry serverEntry : this.favorites) {
            entriesToSave.add(serverEntry);
            favorites.addTag(new StringTag(serverEntry.uuid.toString()));
        }
        CompoundTag history = new CompoundTag();
        for (ServerEntry entry : this.history) {
            entriesToSave.add(entry);
            history.put(entry.uuid.toString(), new LongTag(entry.lastPlayedTime));
        }
        CompoundTag compoundTag = new CompoundTag();
        for (ServerEntry entry : entriesToSave) {
            CompoundTag eTag = new CompoundTag();
            eTag.putString("Address", entry.address);
            if (entry.overrideName != null) {
                eTag.putString("OverrideName", entry.overrideName);
            }
            if (entry.baseName != null) {
                eTag.putString("BaseName", entry.baseName);
            }
            if (entry.showIp) {
                eTag.putBoolean("ShowIp", true);
            }
            compoundTag.put(entry.uuid.toString(), eTag);
        }
        tag.put("ServerData", compoundTag);
        tag.put("Favorites", favorites);
        tag.put("History", history);
        return tag;
    }

    public void addEntry(@NotNull ServerEntry entry) {
        this.idToEntryLock.lock();
        try {
            this.idToEntryMap.put(entry.uuid, entry);
        }
        finally {
            this.idToEntryLock.unlock();
        }
    }

    public void addFavorite(@NotNull ServerEntry entry) {
        this.addEntry(entry);
        if (!this.favoritesMap.containsKey(entry.uuid)) {
            this.favoritesMap.put(entry.uuid, entry);
            this.favorites.add(entry);
        }
    }

    public void onJoined(@NotNull ServerEntry entry) {
        this.addEntry(entry);
        entry.lastPlayedTime = System.currentTimeMillis();
        if (!this.historyMap.containsKey(entry.uuid)) {
            this.historyMap.put(entry.uuid, entry);
            this.history.add(entry);
        }
        this.history.sort((o1, o2) -> Long.compare(o2.lastPlayedTime, o1.lastPlayedTime));
    }

    public void onLocalScanned(@NotNull String ip, int port, @Nullable String motd, @Nullable String name) {
        ServerAddress address = ServerAddress.resolveServerIP(String.format("%s:%s", ip, port));
        if (!this.lanAddressMap.containsKey(address)) {
            ServerEntry entry = new ServerEntry(UUID.randomUUID(), String.format("%s:%s", ip, port));
            entry.baseName = name == null || name.isBlank() ? "Lan Server" : name;
            entry.motd = motd;
            entry.showIp = true;
            entry.addressResolved = address;
            entry.dirty = true;
            entry.requestIcon = true;
            this.addEntry(entry);
            this.lan.add(entry);
            this.lanMap.put(entry.uuid, entry);
            this.lanAddressMap.put(address, entry);
            this.attachedScreen.needToRefreshPages = true;
        }
    }

    public void removeFavorite(@NotNull ServerEntry entry) {
        this.favorites.remove(entry);
        this.favoritesMap.remove(entry.uuid);
        this.checkValid(entry);
    }

    public void removeHistory(@NotNull ServerEntry entry) {
        this.history.remove(entry);
        this.historyMap.remove(entry.uuid);
        this.checkValid(entry);
    }

    public void checkValid(@NotNull ServerEntry entry) {
        if (!(this.favoritesMap.containsKey(entry.uuid) || this.internetMap.containsKey(entry.uuid) || this.historyMap.containsKey(entry.uuid) || this.lanMap.containsKey(entry.uuid))) {
            this.idToEntryMap.remove(entry.uuid);
        }
    }

    public void freeResources() {
        this.idToEntryLock.lock();
        try {
            this.idToEntryMap.forEach((uuid, entry) -> entry.free());
        }
        finally {
            this.idToEntryLock.unlock();
        }
    }

    @NotNull
    public Collection<ServerEntry> getFavorites() {
        return this.favorites;
    }

    @NotNull
    public Collection<ServerEntry> getInternet() {
        return this.internet;
    }

    @NotNull
    public Collection<ServerEntry> getHistory() {
        return this.history;
    }

    @NotNull
    public Collection<ServerEntry> getLan() {
        return this.lan;
    }
}

