/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGeneric;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFence;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericFence<T extends BlockLogicFence>
extends BlockModelGeneric<T> {
    @NotNull
    public final StaticBlockModel post;
    @NotNull
    public final StaticBlockModel side;

    public BlockModelGenericFence(@NotNull Block<T> block, @NotNull String basekey) {
        super(block, BlockModelDispatcher.loadDataModel(basekey + "/inventory"));
        this.post = BlockModelDispatcher.loadDataModel(basekey + "/post").asModel();
        this.side = BlockModelDispatcher.loadDataModel(basekey + "/side").asModel();
    }

    @Override
    public boolean renderAttached(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos, boolean cullFaces, @Nullable IconCoordinate overrideTexture) {
        boolean north = ((BlockLogicFence)this.block.getLogic()).canConnectTo(worldSource, tilePos, Side.NORTH);
        boolean south = ((BlockLogicFence)this.block.getLogic()).canConnectTo(worldSource, tilePos, Side.SOUTH);
        boolean west = ((BlockLogicFence)this.block.getLogic()).canConnectTo(worldSource, tilePos, Side.WEST);
        boolean east = ((BlockLogicFence)this.block.getLogic()).canConnectTo(worldSource, tilePos, Side.EAST);
        if (north) {
            this.side.renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
        }
        if (west) {
            this.side.renderAttached(this, tessellator, worldSource, tilePos, 0, 1, 0, 0.0, 0.0, 0.0, true, cullFaces, overrideTexture);
        }
        if (south) {
            this.side.renderAttached(this, tessellator, worldSource, tilePos, 0, 2, 0, 0.0, 0.0, 0.0, true, cullFaces, overrideTexture);
        }
        if (east) {
            this.side.renderAttached(this, tessellator, worldSource, tilePos, 0, 3, 0, 0.0, 0.0, 0.0, true, cullFaces, overrideTexture);
        }
        return this.post.renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
    }
}

