/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntitySeat;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicSeat
extends BlockLogic {
    public BlockLogicSeat(@NotNull Block<?> block) {
        super(block, Materials.WOOD);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0);
        block.withEntity(() -> new TileEntitySeat(block));
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        TileEntitySeat tileEntity;
        if (world.isBlockNormalCube(tilePos.up(new TilePos()))) {
            return false;
        }
        if (!world.isClientSide && (tileEntity = (TileEntitySeat)world.getTileEntity(tilePos)) != null && tileEntity.getPassenger() == null) {
            player.startRiding(tileEntity);
        }
        return true;
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePosc tilePos, int data) {
        TileEntitySeat tileEntity;
        if (!world.isClientSide && (tileEntity = (TileEntitySeat)world.getTileEntity(tilePos)) != null && tileEntity.getPassenger() != null) {
            tileEntity.ejectRider();
        }
        super.onRemoved(world, tilePos, data);
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        if (dropCause != EnumDropCause.IMPROPER_TOOL) {
            return new ItemStack[]{new ItemStack(Items.SEAT)};
        }
        return null;
    }
}

