/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk.reader;

import com.mojang.nbt.tags.CompoundTag;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.core.NextTickListEntry;
import net.minecraft.core.world.data.ChunkNibbleArray;
import net.minecraft.core.world.data.ChunkUnsignedByteArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChunkReader {
    @NotNull
    protected final CompoundTag tag;

    public ChunkReader(@NotNull CompoundTag chunkTag) {
        this.tag = chunkTag;
    }

    public abstract int getX();

    public abstract int getZ();

    public abstract long getTicksOnUnload();

    public abstract short @Nullable [] getBlocks(int var1);

    @Nullable
    public abstract ChunkUnsignedByteArray getData(int var1);

    @Nullable
    public abstract ChunkNibbleArray getSkyLight(int var1);

    @Nullable
    public abstract ChunkNibbleArray getBlockLight(int var1);

    public abstract short @Nullable [] getHeightMap();

    public abstract int getAverageBlockHeight();

    public abstract boolean getIsTerrainPopulated();

    public abstract double @Nullable [] getTemperatureMap();

    public abstract double @Nullable [] getHumidityMap();

    public abstract byte @Nullable [] getBiomeMap(int var1, @NotNull Int2ObjectMap<String> var2);

    @Nullable
    public abstract Int2ObjectMap<String> getBiomeRegistry();

    @Nullable
    public abstract Int2ObjectMap<NextTickListEntry> getTickList();
}

