/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.noise;

import java.util.Random;
import net.minecraft.core.world.noise.Noise3D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public class ImprovedPerlinNoise
implements Noise3D {
    @NotNull
    private static final Vector2dc RANGE = new Vector2d(-Math.sqrt(0.75), Math.sqrt(0.75));
    @NotNull
    private final LegacyNoiseType legacyNoiseType;
    private final int @NotNull [] p;
    public final double xo;
    public final double yo;
    public final double zo;

    @NotNull
    public static @NotNull ImprovedPerlinNoise @NotNull [] genOctaves(long seed, int numOctaves) {
        return ImprovedPerlinNoise.genOctaves(seed, numOctaves, 0, LegacyNoiseType.DEFAULT);
    }

    @NotNull
    public static @NotNull ImprovedPerlinNoise @NotNull [] genOctaves(long seed, int numOctaves, int preOctaves) {
        return ImprovedPerlinNoise.genOctaves(seed, numOctaves, preOctaves, LegacyNoiseType.DEFAULT);
    }

    @NotNull
    public static @NotNull ImprovedPerlinNoise @NotNull [] genOctaves(long seed, int numOctaves, int preOctaves, @NotNull LegacyNoiseType legacyNoiseType) {
        @NotNull Random random = new Random(seed);
        for (int i = 0; i < preOctaves; ++i) {
            random.nextDouble();
            random.nextDouble();
            random.nextDouble();
            for (int j = 0; j < 256; ++j) {
                random.nextInt(256 - j);
            }
        }
        @NotNull ImprovedPerlinNoise @NotNull [] octaves = new ImprovedPerlinNoise[numOctaves];
        for (int i = 0; i < numOctaves; ++i) {
            octaves[i] = new ImprovedPerlinNoise(random, legacyNoiseType);
        }
        return octaves;
    }

    public ImprovedPerlinNoise(@NotNull Random random) {
        this(random, LegacyNoiseType.DEFAULT);
    }

    public ImprovedPerlinNoise(@NotNull Random random, @NotNull LegacyNoiseType legacyNoiseType) {
        int i;
        this.legacyNoiseType = legacyNoiseType;
        this.p = new int[512];
        this.xo = random.nextDouble() * 256.0;
        this.yo = random.nextDouble() * 256.0;
        this.zo = random.nextDouble() * 256.0;
        for (i = 0; i < 256; ++i) {
            this.p[i] = i;
        }
        for (i = 0; i < 256; ++i) {
            int newI = random.nextInt(256 - i) + i;
            int temp = this.p[i];
            this.p[i] = this.p[newI];
            this.p[newI] = temp;
            this.p[i + 256] = this.p[i];
        }
    }

    @Override
    @NotNull
    public Vector2dc getRange2D() {
        return RANGE;
    }

    @Override
    @NotNull
    public Vector2dc getRange3D() {
        return RANGE;
    }

    @Override
    public double getValue(double x, double z) {
        return this.getValue(x, z, 0.0);
    }

    @Override
    public double getValue(double x, double y, double z) {
        int X = (int)this.fastFloor(x) & 0xFF;
        int Y = (int)this.fastFloor(y) & 0xFF;
        int Z = (int)this.fastFloor(z) & 0xFF;
        x -= this.fastFloor(x);
        y -= this.fastFloor(y);
        z -= this.fastFloor(z);
        double u = this.fade(x);
        double v = this.fade(y);
        double w = this.fade(z);
        int A = this.p[X] + Y;
        int AA = this.p[A] + Z;
        int AB = this.p[A + 1] + Z;
        int B = this.p[X + 1] + Y;
        int BA = this.p[B] + Z;
        int BB = this.p[B + 1] + Z;
        return this.lerp(w, this.lerp(v, this.lerp(u, this.grad(this.p[AA], x, y, z), this.grad(this.p[BA], x - 1.0, y, z)), this.lerp(u, this.grad(this.p[AB], x, y - 1.0, z), this.grad(this.p[BB], x - 1.0, y - 1.0, z))), this.lerp(v, this.lerp(u, this.grad(this.p[AA + 1], x, y, z - 1.0), this.grad(this.p[BA + 1], x - 1.0, y, z - 1.0)), this.lerp(u, this.grad(this.p[AB + 1], x, y - 1.0, z - 1.0), this.grad(this.p[BB + 1], x - 1.0, y - 1.0, z - 1.0))));
    }

    private double grad2(int hash, double x, double y) {
        int h = hash & 0xF;
        double u = (double)(1 - ((h & 8) >> 3)) * x;
        double v = h < 4 ? 0.0 : (h == 12 || h == 14 ? x : y);
        return ((h & 1) != 0 ? -u : u) + ((h & 2) != 0 ? -v : v);
    }

    private double fade(double t) {
        return t * t * t * (t * (t * 6.0 - 15.0) + 10.0);
    }

    private double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    private double grad(int hash, double x, double y, double z) {
        double u;
        int h = hash & 0xF;
        double d = u = h < 8 ? x : y;
        double v = h < 4 ? y : (h == 12 || h == 14 ? x : z);
        return ((h & 1) == 0 ? u : -u) + ((h & 2) == 0 ? v : -v);
    }

    private double fastFloor(double value) {
        if (this.legacyNoiseType.doFarLands) {
            int intComponent = (int)value;
            if (value < (double)intComponent) {
                --intComponent;
            }
            return intComponent;
        }
        return Math.floor(value);
    }

    @Override
    public double @NotNull [] addRegion(double @Nullable [] out, double x, double z, int xSize, int zSize, double xScale, double zScale, double amplitude) {
        return this.addRegion(out, x, z, 0.0, xSize, zSize, 1, xScale, zScale, 1.0, amplitude);
    }

    @Override
    public double @NotNull [] addRegion(double @Nullable [] out, double x, double y, double z, int xSize, int ySize, int zSize, double xScale, double yScale, double zScale, double amplitude) {
        if (out == null || out.length != xSize * ySize * zSize) {
            out = new double[xSize * ySize * zSize];
        }
        if (ySize == 1 && this.legacyNoiseType.handleEdgeCaseY) {
            int i = 0;
            for (int xi = 0; xi < xSize; ++xi) {
                double xx = (x + (double)xi) * xScale + this.xo;
                int X = (int)this.fastFloor(xx) & 0xFF;
                xx -= this.fastFloor(xx);
                double u = this.fade(xx);
                for (int zi = 0; zi < zSize; ++zi) {
                    double zz = (z + (double)zi) * zScale + this.zo;
                    int Z = (int)this.fastFloor(zz) & 0xFF;
                    zz -= this.fastFloor(zz);
                    double w = this.fade(zz);
                    int A = this.p[X];
                    int AA = this.p[A] + Z;
                    int B = this.p[X + 1];
                    int BA = this.p[B] + Z;
                    double value = this.lerp(w, this.lerp(u, this.grad2(this.p[AA], xx, zz), this.grad(this.p[BA], xx - 1.0, 0.0, zz)), this.lerp(u, this.grad(this.p[AA + 1], xx, 0.0, zz - 1.0), this.grad(this.p[BA + 1], xx - 1.0, 0.0, zz - 1.0)));
                    int n = i++;
                    out[n] = out[n] + value * amplitude;
                }
            }
        } else if (zSize == 1 && this.legacyNoiseType.handleEdgeCaseZ) {
            int i = 0;
            for (int xi = 0; xi < xSize; ++xi) {
                double xx = (x + (double)xi) * xScale + this.xo;
                int X = (int)this.fastFloor(xx) & 0xFF;
                xx -= this.fastFloor(xx);
                double u = this.fade(xx);
                for (int yi = 0; yi < ySize; ++yi) {
                    double yy = (y + (double)yi) * yScale + this.zo;
                    int Y = (int)this.fastFloor(yy) & 0xFF;
                    yy -= this.fastFloor(yy);
                    double v = this.fade(yy);
                    int A = this.p[X];
                    int AA = this.p[A] + Y;
                    int B = this.p[X + 1];
                    int BA = this.p[B] + Y;
                    double value = this.lerp(v, this.lerp(u, this.grad2(this.p[AA], xx, yy), this.grad(this.p[BA], xx - 1.0, 0.0, yy)), this.lerp(u, this.grad(this.p[AA + 1], xx, 0.0, yy - 1.0), this.grad(this.p[BA + 1], xx - 1.0, 0.0, yy - 1.0)));
                    int n = i++;
                    out[n] = out[n] + value * amplitude;
                }
            }
        } else {
            double lerpedX = 0.0;
            double lerpedXNegY = 0.0;
            double lerpedXNegZ = 0.0;
            double lerpedXNegYNegZ = 0.0;
            int i = 0;
            int lastY = -1;
            for (int xi = 0; xi < xSize; ++xi) {
                double xx = (x + (double)xi) * xScale + this.xo;
                int X = (int)this.fastFloor(xx) & 0xFF;
                xx -= this.fastFloor(xx);
                double u = this.fade(xx);
                for (int zi = 0; zi < zSize; ++zi) {
                    double zz = (z + (double)zi) * zScale + this.zo;
                    int Z = (int)this.fastFloor(zz) & 0xFF;
                    zz -= this.fastFloor(zz);
                    double w = this.fade(zz);
                    for (int yi = 0; yi < ySize; ++yi) {
                        double yy = (y + (double)yi) * yScale + this.yo;
                        int Y = (int)this.fastFloor(yy) & 0xFF;
                        yy -= this.fastFloor(yy);
                        double v = this.fade(yy);
                        if (yi == 0 || Y != lastY) {
                            lastY = Y;
                            int A = this.p[X] + Y;
                            int AA = this.p[A] + Z;
                            int AB = this.p[A + 1] + Z;
                            int B = this.p[X + 1] + Y;
                            int BA = this.p[B] + Z;
                            int BB = this.p[B + 1] + Z;
                            lerpedX = this.lerp(u, this.grad(this.p[AA], xx, yy, zz), this.grad(this.p[BA], xx - 1.0, yy, zz));
                            lerpedXNegY = this.lerp(u, this.grad(this.p[AB], xx, yy - 1.0, zz), this.grad(this.p[BB], xx - 1.0, yy - 1.0, zz));
                            lerpedXNegZ = this.lerp(u, this.grad(this.p[AA + 1], xx, yy, zz - 1.0), this.grad(this.p[BA + 1], xx - 1.0, yy, zz - 1.0));
                            lerpedXNegYNegZ = this.lerp(u, this.grad(this.p[AB + 1], xx, yy - 1.0, zz - 1.0), this.grad(this.p[BB + 1], xx - 1.0, yy - 1.0, zz - 1.0));
                        }
                        double lerpedXY = this.lerp(v, lerpedX, lerpedXNegY);
                        double lerpedXYNegZ = this.lerp(v, lerpedXNegZ, lerpedXNegYNegZ);
                        double lerpedXYZ = this.lerp(w, lerpedXY, lerpedXYNegZ);
                        int n = i++;
                        out[n] = out[n] + lerpedXYZ * amplitude;
                    }
                }
            }
        }
        return out;
    }

    public static enum LegacyNoiseType {
        DEFAULT(true, true, false),
        ALPHA(false, false, true),
        BETA(true, false, true);

        public final boolean handleEdgeCaseY;
        public final boolean handleEdgeCaseZ;
        public final boolean doFarLands;

        private LegacyNoiseType(boolean handleEdgeCaseY, boolean handleEdgeCaseZ, boolean doFarLands) {
            this.handleEdgeCaseY = handleEdgeCaseY;
            this.handleEdgeCaseZ = handleEdgeCaseZ;
            this.doFarLands = doFarLands;
        }
    }
}

