/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.datagen.recipeBuilders;

import java.util.Objects;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.registry.recipe.RecipeGroup;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryBlastFurnace;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.ItemStack;
import net.minecraft.datagen.recipeBuilders.RecipeBuilder;
import net.minecraft.datagen.recipeBuilders.RecipeBuilderBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeBuilderBlastFurnace
extends RecipeBuilderBase {
    protected RecipeSymbol a;
    protected RecipeSymbol b;

    public RecipeBuilderBlastFurnace(String modID) {
        super(modID);
    }

    public RecipeBuilderBlastFurnace setInput(@NotNull IItemConvertible a, @Nullable IItemConvertible b) {
        if (b != null) {
            return this.setInput(a, 0, b, 0);
        }
        return this.setInput(a, 0);
    }

    public RecipeBuilderBlastFurnace setInput(@NotNull IItemConvertible a) {
        return this.setInput(a, null);
    }

    public RecipeBuilderBlastFurnace setInput(@NotNull IItemConvertible a, int metaA, @Nullable IItemConvertible b, int metaB) {
        if (b != null) {
            return this.setInput(new ItemStack(a, 1, metaA), new ItemStack(b, 1, metaB));
        }
        return this.setInput(new ItemStack(a, 1, metaA));
    }

    public RecipeBuilderBlastFurnace setInput(@NotNull IItemConvertible a, int metaA) {
        return this.setInput(a, metaA, null, 0);
    }

    public RecipeBuilderBlastFurnace setInput(@NotNull ItemStack a, @Nullable ItemStack b) {
        if (b != null) {
            return this.setInput(new RecipeSymbol(a), new RecipeSymbol(b));
        }
        return this.setInput(new RecipeSymbol(a));
    }

    public RecipeBuilderBlastFurnace setInput(@NotNull ItemStack a) {
        return this.setInput(a, null);
    }

    public RecipeBuilderBlastFurnace setInput(@NotNull String itemGroupA, @Nullable String itemGroupB) {
        if (itemGroupB != null) {
            return this.setInput(new RecipeSymbol(itemGroupA), new RecipeSymbol(itemGroupB));
        }
        return this.setInput(new RecipeSymbol(itemGroupA));
    }

    public RecipeBuilderBlastFurnace setInput(@NotNull String itemGroupA) {
        return this.setInput(itemGroupA, null);
    }

    public RecipeBuilderBlastFurnace setInput(@NotNull RecipeSymbol a, @Nullable RecipeSymbol b) {
        RecipeBuilderBlastFurnace builder = this.clone(this);
        builder.a = Objects.requireNonNull(a, "Input symbol must not be null!");
        builder.b = b;
        return builder;
    }

    public RecipeBuilderBlastFurnace setInput(@NotNull RecipeSymbol a) {
        return this.setInput(a, null);
    }

    @Override
    public void create(String recipeID, ItemStack outputStack) {
        Objects.requireNonNull(this.a, "First input symbol must not be null!");
        RecipeGroup<?> group = RecipeBuilder.getRecipeGroup(this.modID, "blast_furnace", new RecipeSymbol(Blocks.FURNACE_BLAST_ACTIVE.getDefaultStack()));
        if (group.getItem(recipeID) != null) {
            throw new IllegalArgumentException("RecipeID '" + recipeID + "' already exists!");
        }
        if (this.b != null) {
            group.register(recipeID, new RecipeEntryBlastFurnace(new RecipeSymbol[]{this.a, this.b}, outputStack));
        } else {
            group.register(recipeID, new RecipeEntryBlastFurnace(new RecipeSymbol[]{this.a}, outputStack));
        }
    }
}

