/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.worldsettings;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.paged.Page;
import net.minecraft.client.gui.paged.PageComponent;
import net.minecraft.client.gui.paged.PageRegistry;
import net.minecraft.client.gui.paged.ScreenPaged;
import net.minecraft.client.gui.worldsettings.CategoryMobSpawningComponent;
import net.minecraft.client.gui.worldsettings.EntryMobSpawningComponent;
import net.minecraft.client.gui.worldsettings.NodeComponent;
import net.minecraft.client.gui.worldsettings.WorldTypeButtonComponent;
import net.minecraft.client.gui.worldsettings.gamerule.BooleanGameRuleComponent;
import net.minecraft.client.gui.worldsettings.settingnode.CategoryComponent;
import net.minecraft.client.gui.worldsettings.settingnode.NestedNodeComponent;
import net.minecraft.core.data.gamerule.GameRule;
import net.minecraft.core.data.gamerule.GameRuleBoolean;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.item.Items;
import net.minecraft.core.lang.text.TranslatableText;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.settings.WorldConfiguration;
import net.minecraft.core.world.settings.WorldSettingNodes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenWorldSettings
extends ScreenPaged
implements WorldConfiguration.ChangeListener {
    @NotNull
    public static final PageRegistry WORLD_SETTINGS_PAGES = new PageRegistry();
    @NotNull
    private static final @NotNull Map<@NotNull Dimension, @NotNull NodeComponent> WORLD_SETTINGS_ROOT_COMPONENTS = new Object2ObjectArrayMap<Dimension, NodeComponent>();
    @NotNull
    public static final Page PAGE_WORLD_SETTINGS;
    @NotNull
    public static final Page PAGE_GAME_RULES;
    @NotNull
    public static final Page PAGE_MOB_SPAWNING;
    @NotNull
    private final WorldConfiguration worldConfiguration;

    public ScreenWorldSettings(@Nullable Screen parent, @NotNull WorldConfiguration worldConfiguration) {
        super(parent, WORLD_SETTINGS_PAGES, PAGE_WORLD_SETTINGS, "gui.world_settings.label.title", new String[]{"gui.world_settings.button.done"});
        this.worldConfiguration = worldConfiguration;
        this.worldConfiguration.setChangeListener(this);
        for (Dimension dimension : WORLD_SETTINGS_ROOT_COMPONENTS.keySet()) {
            Objects.requireNonNull(WORLD_SETTINGS_ROOT_COMPONENTS.get(dimension)).onUpdate(dimension, worldConfiguration);
        }
        List<PageComponent> worldSettingsPageComponents = PAGE_WORLD_SETTINGS.getComponents();
        for (PageComponent pageComponent : worldSettingsPageComponents) {
            if (!(pageComponent instanceof WorldTypeButtonComponent)) continue;
            WorldTypeButtonComponent typeButtonComponent = (WorldTypeButtonComponent)pageComponent;
            typeButtonComponent.setWorldConfiguration(worldConfiguration);
        }
        List<PageComponent> list = PAGE_GAME_RULES.getComponents();
        for (PageComponent component : list) {
            if (!(component instanceof BooleanGameRuleComponent)) continue;
            BooleanGameRuleComponent ruleComponent = (BooleanGameRuleComponent)component;
            ruleComponent.setGameRuleCollection(worldConfiguration.getGameRules());
        }
        List<PageComponent> list2 = PAGE_MOB_SPAWNING.getComponents();
        for (PageComponent component : list2) {
            if (component instanceof EntryMobSpawningComponent) {
                EntryMobSpawningComponent mobSpawningComponent = (EntryMobSpawningComponent)component;
                mobSpawningComponent.setSpawnConfiguration(worldConfiguration);
                continue;
            }
            if (!(component instanceof CategoryMobSpawningComponent)) continue;
            CategoryMobSpawningComponent categoryComponent = (CategoryMobSpawningComponent)component;
            categoryComponent.setSpawnConfiguration(worldConfiguration);
        }
    }

    @Override
    public void onChanged() {
        for (Dimension dimension : WORLD_SETTINGS_ROOT_COMPONENTS.keySet()) {
            Objects.requireNonNull(WORLD_SETTINGS_ROOT_COMPONENTS.get(dimension)).onUpdate(dimension, this.worldConfiguration);
        }
    }

    static {
        for (Dimension dimension : Dimension.getDimensionList().values()) {
            WORLD_SETTINGS_ROOT_COMPONENTS.put(dimension, new NestedNodeComponent(WorldSettingNodes.getRootNode(), 0));
        }
        PAGE_WORLD_SETTINGS = WORLD_SETTINGS_PAGES.register(new Page("gui.world_settings.page.world_settings.title", Items.PAINTBRUSH.getDefaultStack()).withComponent(new WorldTypeButtonComponent("gui.world_settings.label.world_type", null)).withComponent(new CategoryComponent(new TranslatableText("gui.world_settings.page.world_settings.category.overworld")).withComponent(WORLD_SETTINGS_ROOT_COMPONENTS.get(Dimension.OVERWORLD))).withComponent(new CategoryComponent(new TranslatableText("gui.world_settings.page.world_settings.category.nether")).withComponent(WORLD_SETTINGS_ROOT_COMPONENTS.get(Dimension.NETHER))));
        PAGE_GAME_RULES = WORLD_SETTINGS_PAGES.register(new Page("gui.world_settings.page.game_rules.title", Items.PAPER.getDefaultStack()));
        for (GameRule<?> gameRule : Registries.GAME_RULES) {
            if (!(gameRule instanceof GameRuleBoolean)) continue;
            PAGE_GAME_RULES.withComponent(new BooleanGameRuleComponent((GameRuleBoolean)gameRule));
        }
        PAGE_MOB_SPAWNING = WORLD_SETTINGS_PAGES.register(new Page("gui.world_settings.page.mob_spawning.title", Items.EGG_CHICKEN.getDefaultStack()).withComponent(new CategoryMobSpawningComponent(CategoryMobSpawningComponent.Type.HOSTILE)).withComponent(new CategoryMobSpawningComponent(CategoryMobSpawningComponent.Type.PASSIVE)));
        for (EntityDispatcher.EntityDispatcherEntry entityDispatcherEntry : EntityDispatcher.getInstance().entries) {
            if (!Mob.class.isAssignableFrom(entityDispatcherEntry.entityClass) || entityDispatcherEntry.nameKey == null) continue;
            PAGE_MOB_SPAWNING.withComponent(new EntryMobSpawningComponent(entityDispatcherEntry));
        }
    }
}

