/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGeneric;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericTrapdoor<T extends BlockLogic>
extends BlockModelGeneric<T> {
    @NotNull
    public final StaticBlockModel open;
    @NotNull
    public final StaticBlockModel top;

    public BlockModelGenericTrapdoor(@NotNull Block<T> block, @NotNull String basekey) {
        super(block, BlockModelDispatcher.loadDataModel(basekey + "/bottom"));
        this.open = BlockModelDispatcher.loadDataModel(basekey + "/open").asModel();
        this.top = BlockModelDispatcher.loadDataModel(basekey + "/top").asModel();
    }

    @Override
    public boolean renderAttached(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos, boolean cullFaces, @Nullable IconCoordinate overrideTexture) {
        int rotation = worldSource.getBlockData(tilePos) & 3;
        return switch (rotation & 3) {
            case 1 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 2, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            case 2 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 1, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            case 3 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 3, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            default -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
        };
    }

    @Override
    @NotNull
    public StaticBlockModel getModelFromData(int data) {
        if ((data & 4) != 0) {
            return this.open;
        }
        if ((data & 8) != 0) {
            return this.top;
        }
        return this.staticModel;
    }
}

