/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.core.entity.monster.MobScorpion;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.entity.BoneTransform;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class MobRendererScorpion
extends MobRenderer<MobScorpion> {
    public MobRendererScorpion(float shadowSize) {
        super(shadowSize);
    }

    @Override
    @Nullable
    protected StaticEntityModel getAndSetupModelForLayer(@NotNull MobScorpion entity, float brightness, float partialTick, int layer) {
        StaticEntityModel model = this.getModel("main");
        model.resetBones();
        float limbSwing = this.getLimbSwing(entity, partialTick);
        float limbYaw = this.getLimbYaw(entity, partialTick);
        BoneTransform leg0 = model.getTransform("leg0");
        BoneTransform leg1 = model.getTransform("leg1");
        BoneTransform leg2 = model.getTransform("leg2");
        BoneTransform leg3 = model.getTransform("leg3");
        BoneTransform leg4 = model.getTransform("leg4");
        BoneTransform leg5 = model.getTransform("leg5");
        float pair1Y = -(MathHelper.cos(limbSwing * 0.6662f * 2.0f + 0.0f) * 0.4f) * limbYaw;
        float pair2Y = -(MathHelper.cos(limbSwing * 0.6662f * 2.0f + (float)Math.PI) * 0.4f) * limbYaw;
        float pair3Y = -(MathHelper.cos(limbSwing * 0.6662f * 2.0f + 1.5707964f) * 0.4f) * limbYaw;
        leg2.rotZ = leg4.rotZ = -22.5 * (double)MathHelper.DEG_TO_RAD;
        leg0.rotZ = leg4.rotZ;
        leg0.rotY = 30.0f * MathHelper.DEG_TO_RAD - pair2Y;
        leg2.rotY = 0.0f + pair3Y;
        leg4.rotY = -30.0f * MathHelper.DEG_TO_RAD + pair2Y;
        leg3.rotZ = leg5.rotZ = 22.5 * (double)MathHelper.DEG_TO_RAD;
        leg1.rotZ = leg5.rotZ;
        leg1.rotY = -30.0f * MathHelper.DEG_TO_RAD + pair1Y;
        leg3.rotY = 0.0f - pair3Y;
        leg5.rotY = 30.0f * MathHelper.DEG_TO_RAD - pair1Y;
        return model;
    }

    @Override
    protected float getMaxDeathRotation(@NotNull MobScorpion entity) {
        return 180.0f;
    }
}

