/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.settings.impl;

import com.mojang.nbt.tags.FloatTag;
import com.mojang.nbt.tags.Tag;
import java.util.zip.DataFormatException;
import net.minecraft.core.lang.text.LiteralText;
import net.minecraft.core.lang.text.Text;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.save.WorldConfigurationReader;
import net.minecraft.core.world.settings.RangeValueSettingNode;
import net.minecraft.core.world.settings.ValueGenericSettingNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PercentageSettingNode
extends ValueGenericSettingNode<Float>
implements RangeValueSettingNode<Float> {
    private final float defaultValue;

    public PercentageSettingNode(@NotNull String key, @NotNull Text name, float defaultValue) {
        super(key, name, Float.class);
        this.defaultValue = defaultValue;
    }

    @Override
    @NotNull
    public Float getMinimumValue(@NotNull Dimension dimension, @NotNull WorldConfigurationReader config) {
        return Float.valueOf(0.0f);
    }

    @Override
    @NotNull
    public Float getMaximumValue(@NotNull Dimension dimension, @NotNull WorldConfigurationReader config) {
        return Float.valueOf(1.0f);
    }

    @Override
    @NotNull
    public Float getDefaultValue(@NotNull Dimension dimension, @NotNull WorldConfigurationReader config) {
        return Float.valueOf(this.defaultValue);
    }

    @Override
    public boolean validateValue(@NotNull Float value, @NotNull Dimension dimension, @NotNull WorldConfigurationReader config) {
        return value.floatValue() >= this.getMinimumValue(dimension, config).floatValue() && value.floatValue() <= this.getMaximumValue(dimension, config).floatValue();
    }

    @Override
    @NotNull
    public Text getValueText(@Nullable Float value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null!");
        }
        return new LiteralText((int)((double)value.floatValue() * 100.0) + "%");
    }

    @Override
    @NotNull
    public Tag<?> serializeValue(@Nullable Float value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null!");
        }
        return new FloatTag(value.floatValue());
    }

    @Override
    @NotNull
    public Float deserializeValue(@NotNull Tag<?> tag) throws DataFormatException {
        if (tag instanceof FloatTag) {
            @NotNull FloatTag floatTag = (FloatTag)tag;
            return (Float)floatTag.getValue();
        }
        throw new DataFormatException("Tag was wrong type!");
    }
}

