/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texture.meta;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.client.render.texture.meta.TextureProperties;

public class TexturePropertiesAdapter
implements JsonDeserializer<TextureProperties>,
JsonSerializer<TextureProperties> {
    @Override
    public TextureProperties deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jObject = json.getAsJsonObject();
        Boolean blur = null;
        Boolean clamp = null;
        Boolean mip = null;
        if (jObject.has("blur")) {
            blur = jObject.get("blur").getAsBoolean();
        }
        if (jObject.has("clamp")) {
            clamp = jObject.get("clamp").getAsBoolean();
        }
        if (jObject.has("mipmaps")) {
            mip = jObject.get("mipmaps").getAsBoolean();
        }
        return new TextureProperties(blur, clamp, mip);
    }

    @Override
    public JsonElement serialize(TextureProperties src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        obj.addProperty("blur", src.blur);
        obj.addProperty("clamp", src.clamp);
        obj.addProperty("mipmaps", src.mipmap);
        return obj;
    }
}

