/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.ISupportable;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.animal.MobFireflyCluster;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockLogicLanternFirefly
extends BlockLogic
implements ISupportable {
    public static final int MASK_HANGING = 1;
    public static final int MASK_ANGLED = 2;
    private final Supplier<Item> itemSupplier;
    private final MobFireflyCluster.FireflyColor color;

    public BlockLogicLanternFirefly(@NotNull Block<?> block, @NotNull MobFireflyCluster.FireflyColor colour, @NotNull Supplier<Item> itemSupplier) {
        super(block, Materials.GLASS);
        this.color = colour;
        this.itemSupplier = itemSupplier;
        this.setBlockBounds(0.3125, 0.0, 0.3125, 0.6875, 0.5, 0.6875);
    }

    @Override
    @NotNull
    public AABBdc getBoundsFromState(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        int metadata = source.getBlockData(tilePos);
        float offset = 0.0f;
        if ((metadata & 1) != 0) {
            offset = 0.3875f;
        }
        return new AABBd(0.3125, offset, 0.3125, 0.6875, 0.5f + offset, 0.6875);
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        if (rand.nextInt(3) == 0) {
            world.spawnParticle(this.color.getParticleName(), (double)tilePos.x() + (double)rand.nextFloat(), (double)tilePos.y() + (double)rand.nextFloat(), (double)tilePos.z() + (double)rand.nextFloat(), 0.0, 0.0, 0.0, 0);
        }
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        world.setBlockTypeRaw(tilePos, Blocks.AIR);
        world.playSoundAtEntity(player, player, "item.pickup", 1.0f, 1.0f);
        if (!world.isClientSide) {
            world.dropItem(tilePos, new ItemStack(this.itemSupplier.get(), 1, 0));
        }
        world.markBlockDirty(tilePos);
        return true;
    }

    @Override
    public void onPlacedOnSide(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        if ((side == Side.BOTTOM || side != Side.TOP && yHit >= 0.5) && (this.isSupported(world, tilePos, Side.TOP) || world.getBlockType(tilePos.up(new TilePos())).hasTag(BlockTags.CAN_HANG_OFF))) {
            world.setBlockDataNotify(tilePos, 1);
            return;
        }
        if ((side == Side.TOP || side != Side.BOTTOM && yHit < 0.5) && this.isSupported(world, tilePos, Side.BOTTOM)) {
            world.setBlockDataNotify(tilePos, 0);
            return;
        }
        if (this.isSupported(world, tilePos, Side.TOP) || world.getBlockType(tilePos.up(new TilePos())).hasTag(BlockTags.CAN_HANG_OFF)) {
            world.setBlockDataNotify(tilePos, 1);
        } else {
            world.setBlockDataNotify(tilePos, 0);
        }
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePosc tilePos) {
        if (this.isSupported(world, tilePos, Side.TOP) || world.getBlockType(tilePos.up(new TilePos())).hasTag(BlockTags.CAN_HANG_OFF)) {
            return true;
        }
        return this.isSupported(world, tilePos, Side.BOTTOM);
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Block<?> block) {
        if (!this.canStay(world, tilePos)) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
            world.setBlockTypeNotify(tilePos, Blocks.AIR);
        }
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        ItemStack[] itemStackArray;
        switch (dropCause) {
            case PICK_BLOCK: 
            case SILK_TOUCH: 
            case WORLD: {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = new ItemStack(this.itemSupplier.get());
                break;
            }
            default: {
                itemStackArray = null;
            }
        }
        return itemStackArray;
    }

    @Override
    public boolean canStay(@NotNull World world, @NotNull TilePosc tilePos) {
        int meta = world.getBlockData(tilePos);
        if ((meta & 1) != 0) {
            return this.isSupported(world, tilePos, Side.TOP) || world.getBlockType(tilePos.up(new TilePos())).hasTag(BlockTags.CAN_HANG_OFF);
        }
        return this.isSupported(world, tilePos, Side.BOTTOM);
    }

    @Override
    public void onDestroyedByPlayer(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, int data, @NotNull Player player, @Nullable Item item) {
        if (item != null && item.isSilkTouch()) {
            return;
        }
        if (!world.isClientSide) {
            MobFireflyCluster entity = new MobFireflyCluster(world);
            entity.setColor(this.color);
            entity.setFireflyCount(1);
            entity.setClusterSize(0);
            entity.setSizeBasedOnClusterSize(entity.getClusterSize());
            entity.setPos((float)tilePos.x() + 0.5f + (world.rand.nextFloat() - 0.5f) * 0.5f, (float)tilePos.y() + world.rand.nextFloat() * 0.5f, (float)tilePos.z() + 0.5f + (world.rand.nextFloat() - 0.5f) * 0.5f);
            world.entityJoinedWorld(entity);
        }
    }

    @Override
    public int getPistonPushReaction(@NotNull World world, @NotNull TilePosc tilePos) {
        return 1;
    }

    @Override
    @NotNull
    public ISupport getSupportConstraint(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return side.isVertical() ? PartialSupport.INSTANCE.center() : PartialSupport.INSTANCE;
    }
}

