/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFire;
import net.minecraft.core.block.BlockLogicFluid;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.Fluid;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public class FluidLava
implements Fluid {
    @Override
    public int tickDelay() {
        return 30;
    }

    @Override
    public void animationTick(@NotNull BlockLogicFluid logicFluid, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        boolean isTop;
        TilePos up = tilePos.up(new TilePos());
        boolean bl = isTop = world.getBlockMaterial(up) == Materials.AIR && !world.isBlockOpaqueCube(up);
        if (isTop && rand.nextInt(100) == 0) {
            double xOff = (double)tilePos.x() + (double)rand.nextFloat();
            double yOff = (double)tilePos.y() + logicFluid.getBounds().maxY();
            double zOff = (double)tilePos.z() + (double)rand.nextFloat();
            world.spawnParticle("lava", xOff, yOff, zOff, 0.0, 0.0, 0.0, 0);
        }
    }

    @Override
    public boolean checkForHarden(@NotNull BlockLogicFluid logicFluid, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Material encountered) {
        if (encountered == Materials.WATER) {
            int data = world.getBlockData(tilePos) & 0xF;
            if (data == 0) {
                if (world.dimension == Dimension.NETHER) {
                    world.setBlockTypeNotify(tilePos, Blocks.COBBLE_NETHERRACK_IGNEOUS);
                } else {
                    world.setBlockTypeNotify(tilePos, Blocks.OBSIDIAN);
                }
            } else if (data <= 2) {
                world.setBlockTypeNotify(tilePos, Blocks.COBBLE_GRANITE);
            } else if (data <= 4) {
                world.setBlockTypeNotify(tilePos, Blocks.COBBLE_STONE);
            } else {
                world.setBlockTypeNotify(tilePos, Blocks.COBBLE_BASALT);
            }
            BlockLogicFluid.fizz(world, tilePos);
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldTick() {
        return true;
    }

    @Override
    public void updateTickStill(@NotNull BlockLogicFluid logicFluid, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        TilePos p = new TilePos(tilePos);
        TilePos queryPos = new TilePos(tilePos);
        int count = rand.nextInt(3);
        for (int i = 0; i < count; ++i) {
            p.x += rand.nextInt(3) - 1;
            ++p.y;
            p.z += rand.nextInt(3) - 1;
            if (!world.areBlocksLoaded((TilePosc)p, 2)) continue;
            @NotNull Block<?> block = world.getBlockType(p);
            if (block == Blocks.AIR) {
                if (!FluidLava.isFlammable(world, p.west(queryPos)) && !FluidLava.isFlammable(world, p.east(queryPos)) && !FluidLava.isFlammable(world, p.north(queryPos)) && !FluidLava.isFlammable(world, p.south(queryPos)) && !FluidLava.isFlammable(world, p.down(queryPos)) && !FluidLava.isFlammable(world, p.up(queryPos))) continue;
                world.setBlockTypeNotify(p, Blocks.FIRE);
                return;
            }
            if (!block.getMaterial().blocksMotion()) continue;
            return;
        }
    }

    private static boolean isFlammable(World world, @NotNull TilePos tilePos) {
        return BlockLogicFire.canBurn(world, tilePos);
    }

    @Override
    public byte getFlowDecayMod(@NotNull BlockLogicFluid logicFluid, @NotNull World world, @NotNull TilePosc tilePos) {
        if (world.dimension == Dimension.NETHER) {
            return 1;
        }
        return 2;
    }

    @Override
    public boolean canBecomeSource(@NotNull BlockLogicFluid logicFluid, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        return false;
    }

    @Override
    public void onFlowIntoBlock(@NotNull BlockLogicFluid logicFluid, @NotNull World world, @NotNull TilePos tilePos, int meta) {
        BlockLogicFluid.fizz(world, tilePos);
    }

    @Override
    public boolean canSpreadTo(@NotNull BlockLogicFluid logicFluid, @NotNull World world, @NotNull TilePos tilePos, @NotNull Material material) {
        return material != Materials.LAVA;
    }
}

