/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.weather;

import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.save.DimensionData;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.weather.IPrecipitation;
import net.minecraft.core.world.weather.Weather;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeatherManager {
    @NotNull
    private final World world;
    @Nullable
    private Weather lastWeather = null;
    @Nullable
    private Weather currentWeather = null;
    @Nullable
    private Weather nextWeather = null;
    private long weatherDuration = 24000L;
    private float weatherIntensity = 1.0f;
    private float weatherPower = 1.0f;

    public WeatherManager(@NotNull World world) {
        this.world = world;
    }

    public WeatherManager(World world, @Nullable Weather currentWeather, @Nullable Weather nextWeather, long weatherDuration, float weatherPower) {
        this(world);
        this.currentWeather = currentWeather;
        this.nextWeather = nextWeather;
        this.weatherDuration = weatherDuration;
        this.weatherPower = weatherPower;
        this.weatherIntensity = nextWeather != null ? 0.0f : 1.0f;
    }

    @Nullable
    public Weather getLastWeather() {
        return this.lastWeather;
    }

    @Nullable
    public Weather getCurrentWeather() {
        return this.currentWeather;
    }

    @Nullable
    public Weather getNextWeather() {
        return this.nextWeather;
    }

    public long getWeatherDuration() {
        return this.weatherDuration;
    }

    public float getWeatherIntensity() {
        return this.weatherIntensity;
    }

    public float getWeatherPower() {
        return this.weatherPower;
    }

    public void overrideWeather(@Nullable Weather currentWeather, @Nullable Weather nextWeather, long weatherDuration, float weatherIntensity, float weatherPower) {
        this.lastWeather = this.currentWeather;
        this.currentWeather = currentWeather;
        this.nextWeather = nextWeather;
        this.weatherDuration = weatherDuration;
        this.weatherIntensity = weatherIntensity;
        this.weatherPower = weatherPower;
    }

    public void overrideWeather(@Nullable Weather weather, long duration, float power) {
        this.lastWeather = this.currentWeather;
        this.currentWeather = weather;
        this.nextWeather = null;
        this.weatherDuration = duration;
        this.weatherIntensity = 1.0f;
        this.weatherPower = MathHelper.clamp(power, 0.0f, 1.0f);
    }

    public void overrideWeather(@Nullable Weather weather, long duration) {
        this.overrideWeather(weather, duration, this.getRandomWeatherPower());
    }

    public void overrideWeather(@Nullable Weather weather) {
        this.overrideWeather(weather, this.getRandomWeatherDuration());
    }

    public void skip() {
        this.weatherDuration = 0L;
    }

    public boolean tick() {
        if (this.world.getWorldType().hasCeiling()) {
            return false;
        }
        if (this.world.getSeasonManager().getCurrentSeason() == null) {
            return false;
        }
        if (this.currentWeather == null) {
            this.lastWeather = null;
            this.currentWeather = this.world.getWorldType().getDefaultWeather();
            this.weatherDuration = this.getRandomWeatherDuration();
        }
        if (this.nextWeather == null && this.weatherIntensity <= 1.0f) {
            this.weatherIntensity += 0.002f;
            if (this.weatherIntensity > 1.0f) {
                this.weatherIntensity = 1.0f;
            }
        } else if (this.nextWeather != null && this.weatherIntensity >= 0.0f) {
            this.weatherIntensity -= 0.002f;
            if (!this.world.isClientSide && this.currentWeather instanceof IPrecipitation) {
                @NotNull IPrecipitation precipitation = (IPrecipitation)((Object)this.currentWeather);
                if (this.world.dayCanHaveRainbow && this.world.rainbowTicks <= 0 && this.weatherIntensity < 0.5f && precipitation.getPrecipitationType() == IPrecipitation.Type.RAIN_LIKE && !(this.nextWeather instanceof IPrecipitation)) {
                    int rainbowTicks = this.world.rand.nextInt(1800) + 600;
                    this.world.addRainbow(rainbowTicks);
                }
            }
            if (this.weatherIntensity <= 0.0f) {
                this.weatherIntensity = 0.0f;
                this.lastWeather = this.currentWeather;
                this.currentWeather = this.nextWeather;
                this.weatherPower = this.getRandomWeatherPower();
                this.nextWeather = null;
            }
        }
        if (this.world.getGameRuleValue(GameRules.DO_WEATHER_CYCLE).booleanValue()) {
            --this.weatherDuration;
        }
        if (this.weatherDuration <= 0L) {
            if (this.currentWeather != this.world.getWorldType().getDefaultWeather()) {
                this.nextWeather = this.world.getWorldType().getDefaultWeather();
            } else {
                @NotNull Season season = this.world.getSeasonManager().getCurrentSeason();
                boolean foundWeather = false;
                float acc = 0.0f;
                float val = this.world.rand.nextFloat();
                for (int i = 0; i < season.allowedWeathers.size(); ++i) {
                    if (!(val < (acc += season.weatherProbability.get(season.allowedWeathers.get(i)).floatValue()))) continue;
                    this.nextWeather = season.allowedWeathers.get(i);
                    foundWeather = true;
                    break;
                }
                if (!foundWeather) {
                    this.nextWeather = this.world.getWorldType().getDefaultWeather();
                }
            }
            this.weatherDuration = this.getRandomWeatherDuration();
        }
        @NotNull DimensionData dimensionData = this.world.getDimensionData();
        dimensionData.setCurrentWeather(this.currentWeather);
        dimensionData.setNextWeather(this.nextWeather);
        dimensionData.setWeatherDuration(this.weatherDuration);
        dimensionData.setWeatherIntensity(this.weatherIntensity);
        dimensionData.setWeatherPower(this.weatherPower);
        return true;
    }

    private long getRandomWeatherDuration() {
        return (long)(this.world.rand.nextFloat() * 36000.0f + 6000.0f);
    }

    private float getRandomWeatherPower() {
        return this.world.rand.nextFloat() * 0.5f + 0.5f;
    }
}

