/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.terrain;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.culling.CameraFrustum;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;
import org.joml.primitives.AABBd;

public abstract class ChunkRenderer {
    public static final int MAX_RENDER_PASSES = 2;
    public static int updates = 0;
    public final boolean @NotNull [] empty = new boolean[2];
    public boolean visible = false;
    public int id = -1;
    @NotNull
    protected final TilePos pos = new TilePos();
    @NotNull
    protected final Vector3i size = new Vector3i();
    @NotNull
    protected final @NotNull List<@NotNull TileEntity> renderableBlockEntities = new ArrayList<TileEntity>();
    @NotNull
    protected final @NotNull List<@NotNull TileEntity> globalRenderableBlockEntities;
    protected boolean compiled = false;
    @NotNull
    private final Vector3i middlePos = new Vector3i();
    @NotNull
    private final AABBd bb = new AABBd();
    @Nullable
    private World world;
    private boolean dirty = true;

    public ChunkRenderer(@NotNull World world, @NotNull @NotNull List<@NotNull TileEntity> globalRenderableTileEntities, int x, int y, int z, int size) {
        this.world = world;
        this.globalRenderableBlockEntities = globalRenderableTileEntities;
        this.size.set(size);
        this.setPosInner(x, y, z);
    }

    @NotNull
    public World getWorld() {
        assert (this.world != null);
        return this.world;
    }

    public void setPos(int x, int y, int z) {
        if (x != this.pos.x || y != this.pos.y || z != this.pos.z) {
            this.reset();
            this.setPosInner(x, y, z);
            this.setDirty(true);
        }
    }

    private void setPosInner(int x, int y, int z) {
        this.pos.x = x;
        this.pos.y = y;
        this.pos.z = z;
        this.middlePos.x = x + this.size.y / 2;
        this.middlePos.y = y + this.size.y / 2;
        this.middlePos.z = z + this.size.z / 2;
        float radius = 6.0f;
        this.bb.setMin((float)x - 6.0f, (float)y - 6.0f, (float)z - 6.0f);
        this.bb.setMax((float)(x + this.size.x) + 6.0f, (float)(y + this.size.y) + 6.0f, (float)(z + this.size.z) + 6.0f);
    }

    public abstract boolean rebuild(boolean var1);

    public float distanceToEntitySquared(@NotNull Entity entity) {
        float dx = (float)(entity.x - (double)this.middlePos.x);
        float dy = (float)(entity.y - (double)this.middlePos.y);
        float dz = (float)(entity.z - (double)this.middlePos.z);
        return dx * dx + dy * dy + dz * dz;
    }

    public float distanceToCameraSquared(@NotNull ICamera camera) {
        float dx = (float)(camera.getX(1.0f) - (double)this.middlePos.x);
        float dy = (float)(camera.getY(1.0f) - (double)this.middlePos.y);
        float dz = (float)(camera.getZ(1.0f) - (double)this.middlePos.z);
        return dx * dx + dy * dy + dz * dz;
    }

    public void reset() {
        for (int i = 0; i < 2; ++i) {
            this.empty[i] = true;
        }
        this.visible = false;
        this.compiled = false;
    }

    public void delete() {
        this.reset();
        this.world = null;
    }

    public void cull(@NotNull CameraFrustum frustum, float partialTick) {
        this.visible = frustum.isVisible(this.bb, partialTick);
    }

    public boolean isEmpty() {
        if (!this.compiled) {
            return false;
        }
        return this.empty[0] && this.empty[1];
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

