/*
 * Decompiled with CFR 0.152.
 */
package com.b100.xml.element;

import com.b100.utils.InvalidCharacterException;
import com.b100.utils.StringReader;
import com.b100.utils.StringWriter;
import com.b100.xml.element.XmlAttributeList;
import com.b100.xml.element.XmlContentTag;
import com.b100.xml.element.XmlStringTag;

public abstract class XmlTag<E> {
    protected String name;
    protected XmlAttributeList attributes;
    protected E content;

    public XmlTag(String id, E content) {
        if (id == null) {
            throw new NullPointerException();
        }
        if (id.length() == 0) {
            throw new RuntimeException("Empty String");
        }
        this.name = id;
        this.content = content;
    }

    public abstract StringWriter write(StringWriter var1);

    public E content() {
        return this.content;
    }

    public void setContent(E content) {
        this.content = content;
    }

    public XmlAttributeList getAttributes() {
        return this.attributes;
    }

    public void setAttributes(XmlAttributeList attributes) {
        this.attributes = attributes;
    }

    public String name() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static XmlTag<?> read(StringReader reader) {
        XmlTag tag;
        reader.skipWhitespace();
        reader.expectAndSkip("<");
        String id = XmlTag.readId(reader);
        XmlAttributeList attributes = XmlAttributeList.read(reader);
        reader.expectAndSkip(">");
        String closeTag = "</" + id + ">";
        reader.skipWhitespace();
        if (reader.isNext(closeTag)) {
            reader.expectAndSkip(closeTag);
            tag = new XmlStringTag(id, null);
        } else {
            tag = reader.get() == '<' ? XmlTag.readContentTag(id, reader) : XmlTag.readStringTag(id, reader);
        }
        tag.setAttributes(attributes);
        return tag;
    }

    public static XmlContentTag readContentTag(String id, StringReader reader) {
        XmlContentTag tag = new XmlContentTag(id);
        String closeTag = "</" + id + ">";
        do {
            tag.add(XmlTag.read(reader));
            reader.skipWhitespace();
        } while (!reader.isNext("</"));
        reader.expectAndSkip(closeTag);
        return tag;
    }

    public static XmlStringTag readStringTag(String id, StringReader reader) {
        String closeTag = "</" + id + ">";
        Object value = "";
        while (true) {
            if (reader.get() == '<') break;
            value = (String)value + reader.getAndSkip();
        }
        reader.expectAndSkip(closeTag);
        return new XmlStringTag(id, (String)value);
    }

    public static String readId(StringReader reader) {
        Object id = "";
        while (true) {
            if (reader.get() == '/') {
                throw new InvalidCharacterException(reader);
            }
            if (reader.get() == ' ' || reader.get() == '>') {
                return id;
            }
            id = (String)id + reader.getAndSkip();
        }
    }

    public String toString() {
        return this.write(new StringWriter()).toString();
    }

    public XmlContentTag getAsContentTag() {
        return (XmlContentTag)this;
    }

    public XmlStringTag getAsStringTag() {
        return (XmlStringTag)this;
    }
}

