/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.keyboard.keys;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.keyboard.ScreenKeyboard;
import net.minecraft.client.gui.keyboard.keys.Key;

public class ModifierKey
extends Key {
    public static final String ID_MODIFIER_SHIFT = "mod_shift";
    protected final boolean locking;
    protected final String modifierId;

    public ModifierKey(int x, int y, int width, int height, String modifierId, boolean locking) {
        super(x, y, width, height);
        this.locking = locking;
        this.modifierId = modifierId;
        this.setTextures("minecraft:gui/widgets/keyboard/key_shift/up", "minecraft:gui/widgets/keyboard/key_shift/down", "minecraft:gui/widgets/keyboard/key_shift/up_hovered", "minecraft:gui/widgets/keyboard/key_shift/down_hovered");
    }

    @Override
    public void pressAction(Minecraft mc, ScreenKeyboard keyboard, int originX, int originY, int mouseX, int mouseY) {
        super.pressAction(mc, keyboard, originX, originY, mouseX, mouseY);
        if (this.locking) {
            keyboard.setModifierLock(this.modifierId, !keyboard.isModifierLocked(this.modifierId));
        } else {
            keyboard.setModifierState(this.modifierId, !keyboard.isModifierActive(this.modifierId));
        }
    }

    @Override
    public boolean isDown(Minecraft mc, ScreenKeyboard keyboard) {
        return super.isDown(mc, keyboard) || (this.locking ? keyboard.isModifierLocked(this.modifierId) : keyboard.activeModifiers.getOrDefault(this.modifierId, false) != false);
    }

    public static class Serializer
    implements JsonSerializer<ModifierKey>,
    JsonDeserializer<ModifierKey> {
        public static final int DEFAULT_WIDTH = 25;
        public static final int DEFAULT_HEIGHT = 18;
        public static final boolean DEFAULT_LOCKING = false;
        public static final String DEFAULT_MODIFIER_ID = "mod_shift";
        public static final String DEFAULT_TEXTURE_UP = "minecraft:gui/widgets/keyboard/key_shift/up";
        public static final String DEFAULT_TEXTURE_DOWN = "minecraft:gui/widgets/keyboard/key_shift/down";
        public static final String DEFAULT_TEXTURE_UP_HOVERED = "minecraft:gui/widgets/keyboard/key_shift/up_hovered";
        public static final String DEFAULT_TEXTURE_DOWN_HOVERED = "minecraft:gui/widgets/keyboard/key_shift/down_hovered";

        @Override
        public ModifierKey deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int x = obj.get("x").getAsInt();
            int y = obj.get("y").getAsInt();
            int width = obj.has("width") ? obj.get("width").getAsInt() : 25;
            int height = obj.has("height") ? obj.get("height").getAsInt() : 18;
            Key.ButtonEnum button = obj.has("button") ? Key.ButtonEnum.valueOf(obj.get("button").getAsString().toUpperCase(Locale.ROOT)) : null;
            boolean locking = obj.has("toggle") ? obj.get("toggle").getAsBoolean() : false;
            String modId = obj.has("modifier") ? obj.get("modifier").getAsString() : "mod_shift";
            String texUp = DEFAULT_TEXTURE_UP;
            String texDown = DEFAULT_TEXTURE_DOWN;
            String texUpHovered = DEFAULT_TEXTURE_UP_HOVERED;
            String texDownHovered = DEFAULT_TEXTURE_DOWN_HOVERED;
            if (obj.has("textures")) {
                JsonObject textures = obj.getAsJsonObject("textures");
                if (textures.has("up")) {
                    texUp = textures.get("up").getAsString();
                }
                if (textures.has("down")) {
                    texDown = textures.get("down").getAsString();
                }
                if (textures.has("up_hovered")) {
                    texUpHovered = textures.get("up_hovered").getAsString();
                }
                if (textures.has("down_hovered")) {
                    texDownHovered = textures.get("down_hovered").getAsString();
                }
            }
            ModifierKey key = new ModifierKey(x, y, width, height, modId, locking);
            key.setTextures(texUp, texDown, texUpHovered, texDownHovered);
            key.setControllerButton(button);
            return key;
        }

        @Override
        public JsonElement serialize(ModifierKey src, Type typeOfSrc, JsonSerializationContext context) {
            boolean kdh;
            JsonObject object = new JsonObject();
            object.addProperty("type", Key.Serializer.KEY_CLASS_TO_ID.get(src.getClass()));
            object.addProperty("x", src.x);
            object.addProperty("y", src.y);
            if (src.width != 25) {
                object.addProperty("width", src.width);
            }
            if (src.height != 18) {
                object.addProperty("height", src.height);
            }
            if (src.controllerButton != null) {
                object.addProperty("button", src.controllerButton.name().toLowerCase(Locale.ROOT));
            }
            boolean ku = !src.keyUp.namespaceId.toString().equals(DEFAULT_TEXTURE_UP);
            boolean kd = !src.keyDown.namespaceId.toString().equals(DEFAULT_TEXTURE_DOWN);
            boolean kuh = !src.keyUpHovered.namespaceId.toString().equals(DEFAULT_TEXTURE_UP_HOVERED);
            boolean bl = kdh = !src.keyDownHovered.namespaceId.toString().equals(DEFAULT_TEXTURE_DOWN_HOVERED);
            if (ku || kd || kuh || kdh) {
                JsonObject textureObject = new JsonObject();
                if (ku) {
                    textureObject.addProperty("up", src.keyUp.namespaceId.toString());
                }
                if (kd) {
                    textureObject.addProperty("down", src.keyDown.namespaceId.toString());
                }
                if (kuh) {
                    textureObject.addProperty("up_hovered", src.keyUpHovered.namespaceId.toString());
                }
                if (kdh) {
                    textureObject.addProperty("down_hovered", src.keyDownHovered.namespaceId.toString());
                }
                object.add("textures", textureObject);
            }
            if (!src.modifierId.equals("mod_shift")) {
                object.addProperty("modifier", src.modifierId);
            }
            if (src.locking) {
                object.addProperty("toggle", src.locking);
            }
            return object;
        }
    }
}

