/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.data.registry.recipe.adapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.adapter.RecipeJsonAdapter;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingWithTool;
import net.minecraft.core.item.ItemStack;

public class RecipeEntryCraftingWithToolJsonAdapter
implements RecipeJsonAdapter<RecipeEntryCraftingWithTool> {
    @Override
    public RecipeEntryCraftingWithTool deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        RecipeSymbol input = (RecipeSymbol)context.deserialize(object.get("input"), (Type)((Object)RecipeSymbol.class));
        RecipeSymbol tool = (RecipeSymbol)context.deserialize(object.get("tool"), (Type)((Object)RecipeSymbol.class));
        ItemStack output = (ItemStack)context.deserialize(object.get("output"), (Type)((Object)ItemStack.class));
        return new RecipeEntryCraftingWithTool(input, tool, output);
    }

    @Override
    public JsonElement serialize(RecipeEntryCraftingWithTool src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty("name", src.toString());
        object.addProperty("type", Registries.RECIPE_TYPES.getKey(src.getClass()));
        object.add("input", context.serialize(src.inputSymbol));
        object.add("tool", context.serialize(src.toolToUse));
        object.add("output", context.serialize(src.output));
        return object;
    }
}

