/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemFood
extends Item {
    private final int healAmount;
    private final boolean isWolfsFavoriteMeat;
    private final int ticksPerHeal;

    public ItemFood(@NotNull String name, @NotNull String namespaceId, int id, int healAmount, int ticksPerHeal, boolean favouriteWolfMeat, int maxStackSize) {
        super(name, namespaceId, id);
        this.healAmount = healAmount;
        this.ticksPerHeal = ticksPerHeal;
        this.isWolfsFavoriteMeat = favouriteWolfMeat;
        this.maxStackSize = maxStackSize;
    }

    @Override
    @Nullable
    public ItemStack onUse(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Player player) {
        if (player.getHealth() < player.getMaxHealth() && player.getHealth() + player.getTotalHealingRemaining() < player.getMaxHealth() && selfStack.consumeItem(player)) {
            player.eatFood(this);
            world.playSoundAtEntity(player, player, this.ticksPerHeal >= 10 ? "random.bite_extended" : "random.bite", 0.5f + (itemRand.nextFloat() - itemRand.nextFloat()) * 0.1f, 1.1f + (itemRand.nextFloat() - itemRand.nextFloat()) * 0.1f);
        }
        return selfStack;
    }

    public int getHealAmount() {
        return this.healAmount;
    }

    public int getTicksPerHeal() {
        return this.ticksPerHeal;
    }

    public boolean getIsWolfsFavoriteMeat() {
        return this.isWolfsFavoriteMeat;
    }
}

