/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.noise.operator;

import net.minecraft.core.world.noise.Noise2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public class Emboss2D<T extends Noise2D>
implements Noise2D {
    @NotNull
    private final Vector2d range = new Vector2d();
    @NotNull
    protected final T noise;

    public Emboss2D(@NotNull T noise) {
        this.noise = noise;
    }

    @Override
    @NotNull
    public Vector2dc getRange2D() {
        @NotNull Vector2dc noiseRange = this.noise.getRange2D();
        this.range.set(noiseRange.x() - noiseRange.y(), noiseRange.y() - noiseRange.x());
        return this.range;
    }

    @Override
    public double getValue(double x, double z) {
        return this.noise.getValue(x, z) - this.noise.getValue(x + 1.0, z + 1.0);
    }

    @Override
    public double @NotNull [] addRegion(double @Nullable [] out, double x, double z, int xSize, int zSize, double xScale, double zScale, double amplitude) {
        if (out == null || out.length < xSize * zSize) {
            out = new double[xSize * zSize];
        }
        double @NotNull [] valuesA = this.noise.addRegion(null, x, z, xSize, zSize, xScale, zScale, amplitude);
        double @NotNull [] valuesB = this.noise.addRegion(null, x + 1.0, z + 1.0, xSize, zSize, xScale, zScale, amplitude);
        for (int i = 0; i < out.length; ++i) {
            int n = i;
            out[n] = out[n] + (valuesA[i] - valuesB[i]);
        }
        return out;
    }
}

