/*
 * Decompiled with CFR 0.152.
 */
package org.useless.dragonfly.data.entity.mojang;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.util.helper.Direction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.useless.dragonfly.data.entity.mojang.Face;
import org.useless.util.GsonHelper;

public class Cube {
    public final double @NotNull [] origin;
    public final double @NotNull [] size;
    public final @Nullable Face @NotNull [] faces;
    public final double inflate;
    @NotNull
    public final Vector3dc pivot;
    @Nullable
    public final Vector3dc rotation;

    protected Cube(double @NotNull [] origin, double @NotNull [] size, @Nullable Face.Builder @NotNull [] faces, double inflate, @NotNull Vector3d pivot, @Nullable Vector3d rotation) {
        this.origin = origin;
        this.size = size;
        this.pivot = pivot;
        this.rotation = rotation;
        this.faces = new Face[6];
        for (int i = 0; i < 6; ++i) {
            Face.Builder builder = faces[i];
            if (builder == null) continue;
            this.faces[i] = builder.build();
        }
        this.inflate = inflate;
    }

    public static class Builder {
        private final double @NotNull [] origin;
        private final double @NotNull [] size;
        private final @Nullable Face.Builder @NotNull [] faces;
        private double inflate;
        @NotNull
        private final Vector3d pivot;
        @Nullable
        private Vector3d rotation = null;
        private boolean mirror;

        public Builder(double oX, double oY, double oZ, double sX, double sY, double sZ) {
            this.origin = new double[]{oX, oY, oZ};
            this.size = new double[]{sX, sY, sZ};
            this.faces = new Face.Builder[6];
            this.inflate = 0.0;
            this.pivot = new Vector3d();
        }

        public Builder(double @NotNull [] origin, double @NotNull [] size) {
            this.origin = origin;
            this.size = size;
            this.faces = new Face.Builder[6];
            this.inflate = 0.0;
            this.pivot = new Vector3d();
        }

        @NotNull
        public Builder setFaces(double u, double v) {
            double sizeX = this.size[0];
            double sizeY = this.size[1];
            double sizeZ = this.size[2];
            this.faces[Direction.UP.getId()] = new Face.Builder(u + sizeZ, v, sizeX, sizeZ);
            this.faces[Direction.DOWN.getId()] = new Face.Builder(u + sizeX + sizeZ, v + sizeZ, sizeX, -sizeZ);
            this.faces[Direction.NORTH.getId()] = new Face.Builder(u + sizeZ, v + sizeZ, sizeX, sizeY);
            this.faces[Direction.SOUTH.getId()] = new Face.Builder(u + sizeZ * 2.0 + sizeX, v + sizeZ, sizeX, sizeY);
            this.faces[Direction.EAST.getId()] = new Face.Builder(u, v + sizeZ, sizeZ, sizeY);
            this.faces[Direction.WEST.getId()] = new Face.Builder(u + sizeZ + sizeX, v + sizeZ, sizeZ, sizeY);
            return this;
        }

        @NotNull
        public Builder setFace(@NotNull Direction direction, @Nullable Face.Builder builder) {
            this.faces[direction.getId()] = builder;
            return this;
        }

        @NotNull
        public Builder setInflation(double inflation) {
            this.inflate = inflation;
            return this;
        }

        @NotNull
        public Builder setPivot(double x, double y, double z) {
            this.pivot.set(x, y, z);
            return this;
        }

        @NotNull
        public Builder setRotation(double x, double y, double z) {
            if (this.rotation == null) {
                this.rotation = new Vector3d();
            }
            this.rotation.set(x, y, z);
            return this;
        }

        @NotNull
        public Builder setMirror() {
            this.mirror = !this.mirror;
            return this;
        }

        protected void mirror() {
            Face.Builder west = this.faces[Direction.WEST.getId()];
            this.faces[Direction.WEST.getId()] = this.faces[Direction.EAST.getId()];
            this.faces[Direction.EAST.getId()] = west;
            for (Face.Builder builder : this.faces) {
                if (builder == null) continue;
                builder.setMirror();
            }
        }

        @NotNull
        protected Cube build() {
            if (this.mirror) {
                this.mirror();
            }
            return new Cube(this.origin, this.size, this.faces, this.inflate, this.pivot, this.rotation);
        }

        public static class Serializer
        implements JsonSerializer<Builder>,
        JsonDeserializer<Builder> {
            @Override
            public Builder deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject o = json.getAsJsonObject();
                double[] origin = GsonHelper.getAsDoubleArray(o.getAsJsonArray("origin"), 3);
                double[] size = GsonHelper.getAsDoubleArray(o.getAsJsonArray("size"), 3);
                Builder builder = new Builder(origin, size);
                JsonElement uvElement = o.get("uv");
                if (uvElement.isJsonArray()) {
                    double[] uv = GsonHelper.getAsDoubleArray(uvElement, 2);
                    builder.setFaces(uv[0], uv[1]);
                } else if (uvElement.isJsonObject()) {
                    JsonObject uvObject = uvElement.getAsJsonObject();
                    for (Map.Entry<String, JsonElement> faceEntries : uvObject.entrySet()) {
                        Direction direction = Direction.valueOf(faceEntries.getKey().toUpperCase(Locale.ROOT));
                        builder.setFace(direction, (Face.Builder)context.deserialize(faceEntries.getValue(), (Type)((Object)Face.Builder.class)));
                    }
                }
                if (o.has("inflate")) {
                    builder.setInflation(o.get("inflate").getAsDouble());
                }
                if (o.has("pivot")) {
                    double[] pivot = GsonHelper.getAsDoubleArray(o.get("pivot"), 3);
                    builder.setPivot(pivot[0], pivot[1], pivot[2]);
                }
                if (o.has("rotation")) {
                    double[] rotation = GsonHelper.getAsDoubleArray(o.get("rotation"), 3);
                    builder.setRotation(rotation[0], rotation[1], rotation[2]);
                }
                if (o.has("mirror") && o.get("mirror").getAsBoolean()) {
                    builder.setMirror();
                }
                return builder;
            }

            @Override
            public JsonElement serialize(Builder src, Type typeOfSrc, JsonSerializationContext context) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

