/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.core.entity.animal.MobSheep;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.entity.BoneTransform;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class MobRendererSheep
extends MobRenderer<MobSheep> {
    public MobRendererSheep(float shadowSize) {
        super(shadowSize);
    }

    @Override
    @Nullable
    protected StaticEntityModel getAndSetupModelForLayer(@NotNull MobSheep entity, float brightness, float partialTick, int layer) {
        StaticEntityModel model;
        switch (layer) {
            case 1: {
                int colorIndex = entity.getFleeceColor().blockMeta;
                GLRenderer.setColor3f(brightness * MobSheep.FLEECE_COLOR_TABLE[colorIndex][0], brightness * MobSheep.FLEECE_COLOR_TABLE[colorIndex][1], brightness * MobSheep.FLEECE_COLOR_TABLE[colorIndex][2]);
                model = this.getModel("main");
                this.bindTexture("/assets/minecraft/textures/entity/sheep/wool_overlay.png");
                break;
            }
            case 2: {
                int colorIndex = entity.getFleeceColor().blockMeta;
                GLRenderer.setColor3f(brightness * MobSheep.FLEECE_COLOR_TABLE[colorIndex][0], brightness * MobSheep.FLEECE_COLOR_TABLE[colorIndex][1], brightness * MobSheep.FLEECE_COLOR_TABLE[colorIndex][2]);
                model = this.getModel("wool");
                this.bindTexture("/assets/minecraft/textures/entity/sheep/wool_overlay.png");
                break;
            }
            default: {
                model = this.getModel("main");
            }
        }
        model.resetBones();
        BoneTransform head = model.getTransform("head");
        BoneTransform leg0 = model.getTransform("leg0");
        BoneTransform leg1 = model.getTransform("leg1");
        BoneTransform leg2 = model.getTransform("leg2");
        BoneTransform leg3 = model.getTransform("leg3");
        float bodyYaw = this.getBodyYaw(entity, partialTick);
        float headYaw = this.getHeadYaw(entity, partialTick) - bodyYaw;
        float headPitch = this.getHeadPitch(entity, partialTick);
        float limbSwing = this.getLimbSwing(entity, partialTick);
        float limbYaw = this.getLimbYaw(entity, partialTick);
        leg0.rotX = MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw;
        leg1.rotX = MathHelper.cos(limbSwing * 0.6662f + (float)Math.PI) * 1.4f * limbYaw;
        leg2.rotX = MathHelper.cos(limbSwing * 0.6662f + (float)Math.PI) * 1.4f * limbYaw;
        leg3.rotX = MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw;
        float headBobTime = MathHelper.lerp(entity.prevTimeSheepEating, entity.timeSheepEating, partialTick);
        if (entity.getIsSheepEating()) {
            if (headBobTime < 5.0f) {
                float partPercentage = headBobTime / 5.0f;
                head.rotX = -(headPitch * (1.0f - partPercentage) + 60.0f * partPercentage) * MathHelper.DEG_TO_RAD;
                head.rotY = headYaw * (1.0f - partPercentage) * MathHelper.DEG_TO_RAD;
                head.posY = -2.0f * headBobTime;
            } else if (headBobTime < 35.0f) {
                head.rotX = 60.0f * MathHelper.DEG_TO_RAD;
                head.rotY = 0.0;
                head.posY = -10.0f + MathHelper.sin(headBobTime * 0.05f * 30.5f) / 3.0f;
            } else if (headBobTime < 40.0f) {
                float partPercentage = (headBobTime - 35.0f) / 5.0f;
                head.rotX = (headPitch * partPercentage + 60.0f * (1.0f - partPercentage)) * MathHelper.DEG_TO_RAD;
                head.rotY = headYaw * partPercentage * MathHelper.DEG_TO_RAD;
                head.posY = -10.0f + 2.0f * (headBobTime - 34.0f);
            }
        } else {
            head.rotX = headPitch * MathHelper.DEG_TO_RAD;
            head.rotY = headYaw * MathHelper.DEG_TO_RAD;
        }
        return model;
    }

    @Override
    protected int maxRenderLayer(@NotNull MobSheep entity) {
        return entity.getSheared() ? 1 : 2;
    }
}

