/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFlower;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicDeadBush
extends BlockLogicFlower {
    public BlockLogicDeadBush(@NotNull Block<?> block) {
        super(block);
        float halfWidth = 0.4f;
        this.setBlockBounds(0.09999999403953552, 0.0, 0.09999999403953552, 0.9f, 0.8f, 0.9f);
    }

    @Override
    public boolean mayPlaceOn(@NotNull Block<?> block) {
        return block == Blocks.SAND || block == Blocks.DIRT_SCORCHED || block.hasTag(BlockTags.GROWS_FLOWERS);
    }

    @Override
    public @NotNull ItemStack @Nullable [] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        ItemStack[] itemStackArray;
        int quantity = world.rand.nextInt(3);
        switch (dropCause) {
            case SILK_TOUCH: 
            case PICK_BLOCK: {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = new ItemStack(this);
                break;
            }
            default: {
                if (quantity == 0) {
                    itemStackArray = null;
                    break;
                }
                ItemStack[] itemStackArray3 = new ItemStack[1];
                itemStackArray = itemStackArray3;
                itemStackArray3[0] = new ItemStack(Items.STICK, quantity);
            }
        }
        return itemStackArray;
    }
}

