/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.data.gamerule;

import com.mojang.nbt.tags.CompoundTag;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.data.gamerule.GameRule;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.world.settings.WorldConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GameRuleCollection {
    private final Map<GameRule<?>, Object> gameRules = new HashMap();
    @Nullable
    private WorldConfiguration.ChangeListener changeListener;

    public GameRuleCollection() {
        for (GameRule<?> gameRule : Registries.GAME_RULES) {
            this.gameRules.put(gameRule, gameRule.getDefaultValue());
        }
    }

    public void setChangeListener(@Nullable WorldConfiguration.ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    private void notifyChange() {
        if (this.changeListener != null) {
            this.changeListener.onChanged();
        }
    }

    @NotNull
    public <T> T getValue(@NotNull GameRule<T> gameRule) {
        Object o = this.gameRules.get(gameRule);
        if (o == null) {
            o = this.gameRules.put(gameRule, gameRule.getDefaultValue());
        }
        return (T)o;
    }

    public <T> void setValue(GameRule<T> gameRule, T value) {
        this.gameRules.put(gameRule, value);
        this.notifyChange();
    }

    public void setValues(GameRuleCollection collection) {
        if (collection == null) {
            return;
        }
        for (GameRule<?> gameRule : Registries.GAME_RULES) {
            Object o = collection.getValue(gameRule);
            if (o == null) {
                o = gameRule.getDefaultValue();
            }
            this.gameRules.put(gameRule, o);
        }
        this.notifyChange();
    }

    public GameRuleCollection copy() {
        GameRuleCollection out = new GameRuleCollection();
        for (GameRule<?> gameRule : this.gameRules.keySet()) {
            Object o = this.gameRules.get(gameRule);
            out.setValue(gameRule, o);
        }
        return out;
    }

    @NotNull
    public static GameRuleCollection readFromNBT(CompoundTag tag) {
        GameRuleCollection collection = new GameRuleCollection();
        for (GameRule<?> gameRule : Registries.GAME_RULES) {
            collection.setValue(gameRule, gameRule.readFromNBT(tag));
        }
        return collection;
    }

    public static void writeToNBT(CompoundTag tag, GameRuleCollection collection) {
        for (GameRule<?> gameRule : Registries.GAME_RULES) {
            Object o = collection.getValue(gameRule);
            if (o == null) {
                o = gameRule.getDefaultValue();
            }
            gameRule.writeToNBT(tag, o);
        }
    }
}

