/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilderLiteral;
import com.mojang.brigadier.builder.ArgumentBuilderRequired;
import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.ArgumentTypeEntity;
import net.minecraft.core.net.command.exceptions.CommandExceptions;
import net.minecraft.core.net.command.helpers.EntitySelector;
import net.minecraft.core.net.command.util.CommandHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;

public class CommandSpawn
implements CommandManager.CommandRegistry {
    @Override
    public void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((ArgumentBuilderLiteral)((ArgumentBuilderLiteral)((ArgumentBuilderLiteral)((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal("spawn").requires(CommandSource::hasAdmin)).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            Player sender = source.getSender();
            World world = source.getWorld(0);
            TilePos spawnPoint = world.getSpawnPoint();
            if (sender == null) {
                throw CommandExceptions.notInWorld().create();
            }
            if (sender.dimension != 0) {
                source.movePlayerToDimension(sender, 0);
            }
            source.teleportPlayerToPos(sender, (double)spawnPoint.x + 0.5, (float)world.findTopSolidBlock(spawnPoint.x, spawnPoint.z) + sender.heightOffset, (double)spawnPoint.z + 0.5);
            source.sendTranslatableMessage("command.commands.spawn.success", new Object[0]);
            return 1;
        })).then(ArgumentBuilderRequired.argument("players", ArgumentTypeEntity.usernames()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            Player sender = source.getSender();
            World world = source.getWorld(0);
            TilePos spawnPoint = world.getSpawnPoint();
            EntitySelector entitySelector = c.getArgument("players", EntitySelector.class);
            List<? extends Entity> players = entitySelector.get(source);
            for (Entity entity : players) {
                if (((Player)entity).dimension != 0) {
                    source.movePlayerToDimension((Player)entity, 0);
                }
                source.teleportPlayerToPos((Player)entity, (double)spawnPoint.x + 0.5, (float)world.findTopSolidBlock(spawnPoint.x, spawnPoint.z) + entity.heightOffset, (double)spawnPoint.z + 0.5);
                if (entity == sender) {
                    source.sendTranslatableMessage("command.commands.spawn.success", new Object[0]);
                    continue;
                }
                source.sendTranslatableMessage("command.commands.spawn.success_receiver", new Object[0]);
                source.sendTranslatableMessage("command.commands.spawn.success_other", CommandHelper.getEntityName(entity));
            }
            return 1;
        }))).then(ArgumentBuilderLiteral.literal("get").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            TilePos spawnPoint = source.getWorld(0).getSpawnPoint();
            source.sendMessage(I18n.getInstance().translateKeyAndFormat("command.commands.spawn.get", spawnPoint.x, spawnPoint.y, spawnPoint.z));
            return 1;
        })));
    }
}

