/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiMemoryInfo")
public class AIMemoryInfo
extends Struct<AIMemoryInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TEXTURES;
    public static final int MATERIALS;
    public static final int MESHES;
    public static final int NODES;
    public static final int ANIMATIONS;
    public static final int CAMERAS;
    public static final int LIGHTS;
    public static final int TOTAL;

    protected AIMemoryInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected AIMemoryInfo create(long address, @Nullable ByteBuffer container) {
        return new AIMemoryInfo(address, container);
    }

    public AIMemoryInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIMemoryInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int textures() {
        return AIMemoryInfo.ntextures(this.address());
    }

    @NativeType(value="unsigned int")
    public int materials() {
        return AIMemoryInfo.nmaterials(this.address());
    }

    @NativeType(value="unsigned int")
    public int meshes() {
        return AIMemoryInfo.nmeshes(this.address());
    }

    @NativeType(value="unsigned int")
    public int nodes() {
        return AIMemoryInfo.nnodes(this.address());
    }

    @NativeType(value="unsigned int")
    public int animations() {
        return AIMemoryInfo.nanimations(this.address());
    }

    @NativeType(value="unsigned int")
    public int cameras() {
        return AIMemoryInfo.ncameras(this.address());
    }

    @NativeType(value="unsigned int")
    public int lights() {
        return AIMemoryInfo.nlights(this.address());
    }

    @NativeType(value="unsigned int")
    public int total() {
        return AIMemoryInfo.ntotal(this.address());
    }

    public static AIMemoryInfo malloc() {
        return new AIMemoryInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static AIMemoryInfo calloc() {
        return new AIMemoryInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static AIMemoryInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new AIMemoryInfo(MemoryUtil.memAddress(container), container);
    }

    public static AIMemoryInfo create(long address) {
        return new AIMemoryInfo(address, null);
    }

    @Nullable
    public static AIMemoryInfo createSafe(long address) {
        return address == 0L ? null : new AIMemoryInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(AIMemoryInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIMemoryInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static AIMemoryInfo mallocStack() {
        return AIMemoryInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIMemoryInfo callocStack() {
        return AIMemoryInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIMemoryInfo mallocStack(MemoryStack stack) {
        return AIMemoryInfo.malloc(stack);
    }

    @Deprecated
    public static AIMemoryInfo callocStack(MemoryStack stack) {
        return AIMemoryInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIMemoryInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIMemoryInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIMemoryInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIMemoryInfo.calloc(capacity, stack);
    }

    public static AIMemoryInfo malloc(MemoryStack stack) {
        return new AIMemoryInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AIMemoryInfo calloc(MemoryStack stack) {
        return new AIMemoryInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntextures(long struct) {
        return UNSAFE.getInt(null, struct + (long)TEXTURES);
    }

    public static int nmaterials(long struct) {
        return UNSAFE.getInt(null, struct + (long)MATERIALS);
    }

    public static int nmeshes(long struct) {
        return UNSAFE.getInt(null, struct + (long)MESHES);
    }

    public static int nnodes(long struct) {
        return UNSAFE.getInt(null, struct + (long)NODES);
    }

    public static int nanimations(long struct) {
        return UNSAFE.getInt(null, struct + (long)ANIMATIONS);
    }

    public static int ncameras(long struct) {
        return UNSAFE.getInt(null, struct + (long)CAMERAS);
    }

    public static int nlights(long struct) {
        return UNSAFE.getInt(null, struct + (long)LIGHTS);
    }

    public static int ntotal(long struct) {
        return UNSAFE.getInt(null, struct + (long)TOTAL);
    }

    static {
        Struct.Layout layout = AIMemoryInfo.__struct(AIMemoryInfo.__member(4), AIMemoryInfo.__member(4), AIMemoryInfo.__member(4), AIMemoryInfo.__member(4), AIMemoryInfo.__member(4), AIMemoryInfo.__member(4), AIMemoryInfo.__member(4), AIMemoryInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TEXTURES = layout.offsetof(0);
        MATERIALS = layout.offsetof(1);
        MESHES = layout.offsetof(2);
        NODES = layout.offsetof(3);
        ANIMATIONS = layout.offsetof(4);
        CAMERAS = layout.offsetof(5);
        LIGHTS = layout.offsetof(6);
        TOTAL = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<AIMemoryInfo, Buffer>
    implements NativeResource {
        private static final AIMemoryInfo ELEMENT_FACTORY = AIMemoryInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected AIMemoryInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int textures() {
            return AIMemoryInfo.ntextures(this.address());
        }

        @NativeType(value="unsigned int")
        public int materials() {
            return AIMemoryInfo.nmaterials(this.address());
        }

        @NativeType(value="unsigned int")
        public int meshes() {
            return AIMemoryInfo.nmeshes(this.address());
        }

        @NativeType(value="unsigned int")
        public int nodes() {
            return AIMemoryInfo.nnodes(this.address());
        }

        @NativeType(value="unsigned int")
        public int animations() {
            return AIMemoryInfo.nanimations(this.address());
        }

        @NativeType(value="unsigned int")
        public int cameras() {
            return AIMemoryInfo.ncameras(this.address());
        }

        @NativeType(value="unsigned int")
        public int lights() {
            return AIMemoryInfo.nlights(this.address());
        }

        @NativeType(value="unsigned int")
        public int total() {
            return AIMemoryInfo.ntotal(this.address());
        }
    }
}

