/*
 * Decompiled with CFR 0.152.
 */
package org.useless.dragonfly.data.block.mojang;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Locale;
import net.minecraft.core.util.helper.Direction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.util.GsonHelper;

public class Face {
    protected static final int DEFAULT_ROTATION = 0;
    protected static final int DEFAULT_TINT_INDEX = -1;
    public final float u1;
    public final float u2;
    public final float v1;
    public final float v2;
    public final String texture;
    @Nullable
    public final Direction cullFace;
    public final int rotation;
    public final int tintIndex;

    protected Face(float u1, float u2, float v1, float v2, @NotNull String texture, @Nullable Direction cullFace, int rotation, int tintIndex) {
        this.u1 = u1;
        this.u2 = u2;
        this.v1 = v1;
        this.v2 = v2;
        this.texture = texture;
        this.cullFace = cullFace;
        this.rotation = rotation;
        this.tintIndex = tintIndex;
    }

    public String toString() {
        return "Face{u1=" + this.u1 + ", u2=" + this.u2 + ", v1=" + this.v1 + ", v2=" + this.v2 + ", texture='" + this.texture + "', cullFace=" + String.valueOf((Object)this.cullFace) + ", rotation=" + this.rotation + ", tintIndex=" + this.tintIndex + "}";
    }

    public static class Builder {
        @Nullable
        protected Float u1 = null;
        @Nullable
        protected Float u2 = null;
        @Nullable
        protected Float v1 = null;
        @Nullable
        protected Float v2 = null;
        protected boolean mirrorU = false;
        protected boolean mirrorV = false;
        @NotNull
        protected final String texture;
        @Nullable
        protected Direction cullFace = null;
        protected int rotation = 0;
        protected int tintIndex = -1;

        public Builder(@NotNull String texture) {
            this.texture = texture;
        }

        @NotNull
        public Builder setUVs(float u1, float v1, float u2, float v2) {
            this.u1 = Float.valueOf(u1);
            this.u2 = Float.valueOf(u2);
            this.v1 = Float.valueOf(v1);
            this.v2 = Float.valueOf(v2);
            return this;
        }

        @NotNull
        public Builder setMirrorU(boolean mirrorU) {
            this.mirrorU = mirrorU;
            return this;
        }

        @NotNull
        public Builder setMirrorV(boolean mirrorV) {
            this.mirrorV = mirrorV;
            return this;
        }

        @NotNull
        public Builder setCullFace(@NotNull Direction cullFace) {
            this.cullFace = cullFace;
            return this;
        }

        @NotNull
        public Builder setRotation(int rotation) {
            this.rotation = rotation;
            return this;
        }

        @NotNull
        public Builder setTintIndex(int tintIndex) {
            this.tintIndex = tintIndex;
            return this;
        }

        @NotNull
        protected Face build(float fromX, float fromY, float fromZ, float toX, float toY, float toZ, @NotNull Direction sideFacing) {
            float y2;
            float y1;
            float x2;
            float x1;
            if (this.u1 == null || this.u2 == null || this.v1 == null || this.v2 == null) {
                switch (sideFacing) {
                    case UP: {
                        x1 = fromX;
                        x2 = toX;
                        y1 = fromZ;
                        y2 = toZ;
                        break;
                    }
                    case DOWN: {
                        x1 = fromX;
                        x2 = toX;
                        y1 = 16.0f - toZ;
                        y2 = 16.0f - fromZ;
                        break;
                    }
                    case NORTH: {
                        x1 = 16.0f - toX;
                        x2 = 16.0f - fromX;
                        y1 = 16.0f - toY;
                        y2 = 16.0f - fromY;
                        break;
                    }
                    case SOUTH: {
                        x1 = fromX;
                        x2 = toX;
                        y1 = 16.0f - toY;
                        y2 = 16.0f - fromY;
                        break;
                    }
                    case WEST: {
                        x1 = fromZ;
                        x2 = toZ;
                        y1 = 16.0f - toY;
                        y2 = 16.0f - fromY;
                        break;
                    }
                    case EAST: {
                        x1 = 16.0f - toZ;
                        x2 = 16.0f - fromZ;
                        y1 = 16.0f - toY;
                        y2 = 16.0f - fromY;
                        break;
                    }
                    default: {
                        x1 = 0.0f;
                        x2 = 16.0f;
                        y1 = 0.0f;
                        y2 = 16.0f;
                        break;
                    }
                }
            } else {
                x1 = this.u1.floatValue();
                x2 = this.u2.floatValue();
                y1 = this.v1.floatValue();
                y2 = this.v2.floatValue();
            }
            if (this.mirrorU) {
                float _x = x2;
                x2 = x1;
                x1 = _x;
            }
            if (this.mirrorV) {
                float _y = y2;
                y2 = y1;
                y1 = _y;
            }
            return new Face(x1, x2, y1, y2, this.texture, this.cullFace, this.rotation, this.tintIndex);
        }

        public static class Serializer
        implements JsonSerializer<Builder>,
        JsonDeserializer<Builder> {
            @Override
            public Builder deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject object = json.getAsJsonObject();
                Builder builder = new Builder(object.get("texture").getAsString());
                if (object.has("uv")) {
                    float[] uvs = GsonHelper.getAsFloatArray(object.get("uv"), 4);
                    builder.setUVs(uvs[0], uvs[1], uvs[2], uvs[3]);
                }
                if (object.has("cullface")) {
                    builder.setCullFace(Direction.valueOf(object.get("cullface").getAsString().toUpperCase(Locale.ROOT)));
                }
                if (object.has("rotation")) {
                    builder.setRotation(object.get("rotation").getAsInt());
                }
                if (object.has("tintindex")) {
                    builder.setTintIndex(object.get("tintindex").getAsInt());
                }
                return builder;
            }

            @Override
            public JsonElement serialize(Builder src, Type typeOfSrc, JsonSerializationContext context) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

