/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.console.shell;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BindManager {
    @NotNull
    private static final BindManager INSTANCE = new BindManager();
    @NotNull
    private @NotNull Int2ObjectMap<@NotNull Runnable> keyToRunnableMap = new Int2ObjectOpenHashMap<Runnable>();

    @NotNull
    public static BindManager getInstance() {
        return INSTANCE;
    }

    @NotNull
    public IntCollection getKeys() {
        return this.keyToRunnableMap.keySet();
    }

    @Nullable
    public Runnable getActionForKey(int key) {
        if (this.keyToRunnableMap.containsKey(key)) {
            return (Runnable)this.keyToRunnableMap.get(key);
        }
        return null;
    }

    public void bindKeyToAction(int key, @Nullable Runnable action) {
        if (action == null) {
            this.keyToRunnableMap.remove(key);
        } else {
            this.keyToRunnableMap.put(key, action);
        }
    }
}

