/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.block.Block;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemPlaceable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemRope
extends ItemPlaceable {
    public ItemRope(@NotNull String name, @NotNull String namespaceId, int id, @NotNull Block<?> blockToPlace) {
        super(name, namespaceId, id, blockToPlace);
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc blockPos, @NotNull Side side, double xHit, double yHit) {
        if (selfStack.stackSize <= 0) {
            return false;
        }
        TilePos bp = new TilePos(blockPos);
        boolean placeOnSide = true;
        if (world.getBlockType(bp) == this.blockToPlace && player != null && !player.isSneaking()) {
            placeOnSide = false;
            TilePos tempPos = new TilePos(bp);
            int _y = bp.y;
            while (_y > 0) {
                if (world.canBlockIdBePlacedAt(this.blockToPlace.id(), tempPos.set(bp.x, --_y, bp.z), false, side)) {
                    bp.y = _y;
                    break;
                }
                if (world.getBlockType(tempPos.sub(bp.x, _y, bp.z, new TilePos())) == this.blockToPlace) continue;
                if (side == Side.TOP) break;
                return true;
            }
        }
        if (!world.canPlaceInsideBlock(bp)) {
            bp = bp.add(side.getDirection(), new TilePos());
        }
        if (bp.y < 0 || bp.y >= world.getHeightBlocks()) {
            return false;
        }
        if (world.canBlockIdBePlacedAt(this.blockToPlace.id(), bp, false, side) && selfStack.consumeItem(player) && world.setBlockTypeDataNotify(bp, this.blockToPlace, placeOnSide ? 128 : 0)) {
            if (player == null) {
                this.blockToPlace.onPlacedOnSide(world, bp, side, xHit, yHit);
            } else {
                this.blockToPlace.onPlacedByMob(world, bp, side, player, xHit, yHit);
            }
            world.playBlockSoundEffect(player, (float)bp.x + 0.5f, (float)bp.y + 0.5f, (float)bp.z + 0.5f, this.blockToPlace, EnumBlockSoundEffectType.PLACE);
            return true;
        }
        return false;
    }
}

