/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.lang.text;

import net.minecraft.core.lang.text.ChainText;
import net.minecraft.core.lang.text.FormattedText;
import net.minecraft.core.lang.text.FunctionText;
import net.minecraft.core.lang.text.IntoText;
import net.minecraft.core.lang.text.LiteralText;
import net.minecraft.core.lang.text.TranslatableText;
import net.minecraft.core.net.command.TextFormatting;
import org.jetbrains.annotations.NotNull;

public abstract class Text
implements IntoText {
    @NotNull
    public static Text text() {
        return new ChainText(new Text[0]);
    }

    @NotNull
    public String toString() {
        @NotNull StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    @Override
    @NotNull
    public Text intoText() {
        return this;
    }

    abstract void toString(@NotNull StringBuilder var1);

    @NotNull
    public Text trans(@NotNull String languageKey) {
        return new ChainText(this, new TranslatableText(languageKey));
    }

    @NotNull
    public Text func(@NotNull FunctionText.TextGenerator generator) {
        return new ChainText(this, new FunctionText(generator));
    }

    @NotNull
    public Text lit(@NotNull String literal) {
        return new ChainText(this, new LiteralText(literal));
    }

    @NotNull
    public Text fmt(@NotNull TextFormatting formatting, @NotNull Text text) {
        return new ChainText(this, new FormattedText(formatting, text));
    }
}

