/*
 * Decompiled with CFR 0.152.
 */
package org.useless.dragonfly.data.block.mojang;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.util.helper.Direction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.data.block.mojang.Face;
import org.useless.dragonfly.data.block.mojang.Rotation;
import org.useless.util.GsonHelper;

public class Element {
    protected static final boolean DEFAULT_SHADE = true;
    protected static final int DEFAULT_LIGHT_EMISSION = 0;
    public final float fromX;
    public final float fromY;
    public final float fromZ;
    public final float toX;
    public final float toY;
    public final float toZ;
    @Nullable
    public final Rotation rotation;
    public final boolean shade;
    public final int lightEmission;
    @NotNull
    public final @NotNull Map<@NotNull Direction, @NotNull Face> faces;

    protected Element(float fromX, float fromY, float fromZ, float toX, float toY, float toZ, @Nullable Rotation rotation, boolean shade, int lightEmission, @NotNull @NotNull Map<@NotNull Direction, @NotNull Face> faces) {
        this.fromX = fromX;
        this.fromY = fromY;
        this.fromZ = fromZ;
        this.toX = toX;
        this.toY = toY;
        this.toZ = toZ;
        this.rotation = rotation;
        this.shade = shade;
        this.lightEmission = lightEmission;
        this.faces = faces;
    }

    public String toString() {
        return "Element{fromX=" + this.fromX + ", fromY=" + this.fromY + ", fromZ=" + this.fromZ + ", toX=" + this.toX + ", toY=" + this.toY + ", toZ=" + this.toZ + ", rotation=" + String.valueOf(this.rotation) + ", shade=" + this.shade + ", lightEmission=" + this.lightEmission + ", faces=" + String.valueOf(this.faces) + "}";
    }

    public static class Builder {
        protected final float fromX;
        protected final float fromY;
        protected final float fromZ;
        protected final float toX;
        protected final float toY;
        protected final float toZ;
        @Nullable
        protected Rotation rotation = null;
        protected boolean shade = true;
        protected int lightEmission = 0;
        @NotNull
        protected final @NotNull Map<@NotNull Direction, @NotNull Face.Builder> faces = new HashMap<Direction, Face.Builder>();

        public Builder(float fromX, float fromY, float fromZ, float toX, float toY, float toZ) {
            this.fromX = fromX;
            this.fromY = fromY;
            this.fromZ = fromZ;
            this.toX = toX;
            this.toY = toY;
            this.toZ = toZ;
        }

        @NotNull
        public Builder setRotation(@Nullable Rotation.Builder rotation) {
            this.rotation = rotation == null ? null : rotation.build();
            return this;
        }

        @NotNull
        public Builder setShade(boolean shade) {
            this.shade = shade;
            return this;
        }

        @NotNull
        public Builder setLightEmission(int lightEmission) {
            this.lightEmission = lightEmission;
            return this;
        }

        @NotNull
        public Builder addFace(@NotNull Direction direction, @NotNull Face.Builder face) {
            this.faces.put(direction, face);
            return this;
        }

        @NotNull
        protected Element build() {
            HashMap<Direction, Face> faceMap = new HashMap<Direction, Face>();
            for (Map.Entry<Direction, Face.Builder> e : this.faces.entrySet()) {
                faceMap.put(e.getKey(), e.getValue().build(this.fromX, this.fromY, this.fromZ, this.toX, this.toY, this.toZ, e.getKey()));
            }
            return new Element(this.fromX, this.fromY, this.fromZ, this.toX, this.toY, this.toZ, this.rotation, this.shade, this.lightEmission, faceMap);
        }

        public static class Serializer
        implements JsonSerializer<Builder>,
        JsonDeserializer<Builder> {
            @Override
            public Builder deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject object = json.getAsJsonObject();
                float[] from = GsonHelper.getAsFloatArray(object.get("from"), 3);
                float[] to = GsonHelper.getAsFloatArray(object.get("to"), 3);
                Builder builder = new Builder(from[0], from[1], from[2], to[0], to[1], to[2]);
                if (object.has("rotation")) {
                    builder.setRotation((Rotation.Builder)context.deserialize(object.get("rotation"), (Type)((Object)Rotation.Builder.class)));
                }
                if (object.has("shade")) {
                    builder.setShade(object.get("shade").getAsBoolean());
                }
                if (object.has("light_emission")) {
                    builder.setLightEmission(object.get("light_emission").getAsInt());
                }
                JsonObject faces = object.getAsJsonObject("faces");
                for (Map.Entry<String, JsonElement> e : faces.entrySet()) {
                    builder.addFace(Direction.valueOf(e.getKey().toUpperCase(Locale.ROOT)), (Face.Builder)context.deserialize(e.getValue(), (Type)((Object)Face.Builder.class)));
                }
                return builder;
            }

            @Override
            public JsonElement serialize(Builder src, Type typeOfSrc, JsonSerializationContext context) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

