#version 410 core
layout (lines) in;
layout (triangle_strip, max_vertices = 4) out;

in VS_OUT {
    vec4 color;
} gs_in[];

out vec4 Color;

uniform vec2 uViewPortSize;
uniform float uLineWidth;

void main()
{
    vec4 p1 = gl_in[0].gl_Position;
    vec4 p2 = gl_in[1].gl_Position;

    vec2 dir    = normalize((p2.xy/p2.w - p1.xy/p1.w) * uViewPortSize);
    vec2 offset = vec2(-dir.y, dir.x) * uLineWidth / uViewPortSize;

    Color = gs_in[0].color;
    gl_Position = p1 + vec4(offset.xy * p1.w, 0.0, 0.0);
    EmitVertex();

    Color = gs_in[0].color;
    gl_Position = p1 - vec4(offset.xy * p1.w, 0.0, 0.0);
    EmitVertex();

    Color = gs_in[1].color;
    gl_Position = p2 + vec4(offset.xy * p2.w, 0.0, 0.0);
    EmitVertex();

    Color = gs_in[1].color;
    gl_Position = p2 - vec4(offset.xy * p2.w, 0.0, 0.0);
    EmitVertex();

    EndPrimitive();
}