/*
 * Decompiled with CFR 0.152.
 */
package com.codewaves.codehighlight.core;

import com.codewaves.codehighlight.core.HighlightParser;
import com.codewaves.codehighlight.core.Language;
import com.codewaves.codehighlight.core.StyleRenderer;
import com.codewaves.codehighlight.core.StyleRendererFactory;
import com.codewaves.codehighlight.languages.ApacheLanguage;
import com.codewaves.codehighlight.languages.BashLanguage;
import com.codewaves.codehighlight.languages.CppLanguage;
import com.codewaves.codehighlight.languages.CsLanguage;
import com.codewaves.codehighlight.languages.CssLanguage;
import com.codewaves.codehighlight.languages.DiffLanguage;
import com.codewaves.codehighlight.languages.GoLanguage;
import com.codewaves.codehighlight.languages.GroovyLanguage;
import com.codewaves.codehighlight.languages.HttpLanguage;
import com.codewaves.codehighlight.languages.IniLanguage;
import com.codewaves.codehighlight.languages.JavaLanguage;
import com.codewaves.codehighlight.languages.JsLanguage;
import com.codewaves.codehighlight.languages.JsonLanguage;
import com.codewaves.codehighlight.languages.MakefileLanguage;
import com.codewaves.codehighlight.languages.MarkdownLanguage;
import com.codewaves.codehighlight.languages.ObjCLanguage;
import com.codewaves.codehighlight.languages.PerlLanguage;
import com.codewaves.codehighlight.languages.PhpLanguage;
import com.codewaves.codehighlight.languages.PythonLanguage;
import com.codewaves.codehighlight.languages.RubyLanguage;
import com.codewaves.codehighlight.languages.ScalaLanguage;
import com.codewaves.codehighlight.languages.ShellLanguage;
import com.codewaves.codehighlight.languages.SqlLanguage;
import com.codewaves.codehighlight.languages.XmlLanguage;
import com.codewaves.codehighlight.languages.YamlLanguage;
import java.util.HashMap;
import java.util.Map;

public class Highlighter<E> {
    private static final Map<String, Language> mLanguageMap;
    private static final String[] mLanguages;
    private StyleRendererFactory<E> mRendererFactory;

    private static void registerLanguage(String name, Map<String, Language> languages, Language language) {
        languages.put(name, language);
        if (language.aliases != null) {
            for (String alias : language.aliases) {
                languages.put(alias, language);
            }
        }
    }

    static Language findLanguage(String name) {
        return mLanguageMap.get(name);
    }

    public Highlighter(StyleRendererFactory<E> factory) {
        this.mRendererFactory = factory;
    }

    public HighlightResult<E> highlight(String languageName, String code) {
        StyleRenderer<E> renderer = this.mRendererFactory.create(languageName);
        Language language = mLanguageMap.get(languageName);
        if (language == null) {
            renderer.onPushOriginalSubLanguage(null, code);
            return new HighlightResult<E>(0, null, renderer.getResult());
        }
        HighlightParser<E> parser = new HighlightParser<E>(language, this.mRendererFactory, renderer);
        int relevance = parser.highlight(code, false, null);
        return new HighlightResult<E>(relevance, languageName, renderer.getResult());
    }

    public HighlightResult<E> highlightAuto(String code, String[] languageSubset) {
        String[] languages = languageSubset == null || languageSubset.length == 0 ? mLanguages : languageSubset;
        int bestRelevance = 0;
        String bestLanguageName = null;
        Object result = null;
        for (String languageName : languages) {
            StyleRenderer<E> renderer;
            HighlightParser<E> parser;
            int relevance;
            Language language = mLanguageMap.get(languageName);
            if (language == null || (relevance = (parser = new HighlightParser<E>(language, this.mRendererFactory, renderer = this.mRendererFactory.create(languageName))).highlight(code, false, null)) <= bestRelevance) continue;
            bestRelevance = relevance;
            bestLanguageName = languageName;
            result = renderer.getResult();
        }
        return new HighlightResult<Object>(bestRelevance, bestLanguageName, result);
    }

    static {
        HashMap<String, Language> languages = new HashMap<String, Language>();
        Highlighter.registerLanguage("apache", languages, new ApacheLanguage().build());
        Highlighter.registerLanguage("bash", languages, new BashLanguage().build());
        Highlighter.registerLanguage("cpp", languages, new CppLanguage().build());
        Highlighter.registerLanguage("cs", languages, new CsLanguage().build());
        Highlighter.registerLanguage("css", languages, new CssLanguage().build());
        Highlighter.registerLanguage("diff", languages, new DiffLanguage().build());
        Highlighter.registerLanguage("groovy", languages, new GroovyLanguage().build());
        Highlighter.registerLanguage("go", languages, new GoLanguage().build());
        Highlighter.registerLanguage("http", languages, new HttpLanguage().build());
        Highlighter.registerLanguage("ini", languages, new IniLanguage().build());
        Highlighter.registerLanguage("java", languages, new JavaLanguage().build());
        Highlighter.registerLanguage("javascript", languages, new JsLanguage().build());
        Highlighter.registerLanguage("json", languages, new JsonLanguage().build());
        Highlighter.registerLanguage("makefile", languages, new MakefileLanguage().build());
        Highlighter.registerLanguage("markdown", languages, new MarkdownLanguage().build());
        Highlighter.registerLanguage("objectivec", languages, new ObjCLanguage().build());
        Highlighter.registerLanguage("perl", languages, new PerlLanguage().build());
        Highlighter.registerLanguage("php", languages, new PhpLanguage().build());
        Highlighter.registerLanguage("python", languages, new PythonLanguage().build());
        Highlighter.registerLanguage("ruby", languages, new RubyLanguage().build());
        Highlighter.registerLanguage("scala", languages, new ScalaLanguage().build());
        Highlighter.registerLanguage("shell", languages, new ShellLanguage().build());
        Highlighter.registerLanguage("sql", languages, new SqlLanguage().build());
        Highlighter.registerLanguage("xml", languages, new XmlLanguage().build());
        Highlighter.registerLanguage("yaml", languages, new YamlLanguage().build());
        mLanguageMap = languages;
        mLanguages = new String[]{"apache", "bash", "cpp", "cs", "css", "diff", "go", "groovy", "http", "ini", "java", "javascript", "json", "makefile", "markdown", "objectivec", "perl", "php", "python", "ruby", "scala", "shell", "sql", "xml", "yaml"};
    }

    public static class HighlightResult<R> {
        private int relevance;
        private String language;
        private R result;

        HighlightResult(int relevance, String language, R result) {
            this.relevance = relevance;
            this.language = language;
            this.result = result;
        }

        public int getRelevance() {
            return this.relevance;
        }

        public String getLanguage() {
            return this.language;
        }

        public R getResult() {
            return this.result;
        }
    }
}

