/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.input.controller.ControllerInput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControllerGlyphElement
extends Gui {
    public static final int GLYPH_WIDTH = 15;
    public static final int GLYPH_HEIGHT = 15;
    private static final int GLYPH_U = 0;
    private static final int GLYPH_V = 118;
    @NotNull
    private final Minecraft minecraft;

    public ControllerGlyphElement(@NotNull Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    public void drawGlyph(@Nullable ControllerInput controller, @NotNull Glyph glyph, int x, int y) {
        if (controller == null) {
            this.minecraft.textureManager.loadTexture("/assets/minecraft/textures/gui/controller/xbox_one.png").bind();
        } else {
            this.minecraft.textureManager.loadTexture("/assets/minecraft/textures/gui/controller/" + controller.getType().getAssetName() + ".png").bind();
        }
        this.drawTexturedModalRect(x, y, glyph.getU(), glyph.getV(), 15, 15);
    }

    public static enum Glyph {
        BUTTON_A(0, 118),
        BUTTON_B(15, 118),
        BUTTON_X(30, 118),
        BUTTON_Y(45, 118),
        D_PAD_UP(60, 118),
        D_PAD_RIGHT(75, 118),
        D_PAD_DOWN(90, 118),
        D_PAD_LEFT(105, 118),
        SHOULDER_LEFT(0, 133),
        SHOULDER_RIGHT(15, 133),
        TRIGGER_LEFT(30, 133),
        TRIGGER_RIGHT(45, 133),
        STICK_LEFT_PRESS(60, 133),
        STICK_RIGHT_PRESS(75, 133),
        BUTTON_START(90, 133),
        BUTTON_BACK(105, 133),
        STICK_LEFT_UP(0, 148),
        STICK_LEFT_RIGHT(15, 148),
        STICK_LEFT_DOWN(30, 148),
        STICK_LEFT_LEFT(45, 148),
        STICK_RIGHT_UP(60, 148),
        STICK_RIGHT_RIGHT(75, 148),
        STICK_RIGHT_DOWN(90, 148),
        STICK_RIGHT_LEFT(105, 148);

        private final int u;
        private final int v;

        private Glyph(int u, int v) {
            this.u = u;
            this.v = v;
        }

        public int getU() {
            return this.u;
        }

        public int getV() {
            return this.v;
        }
    }
}

