/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGenericDoor;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.DyeColor;
import org.jetbrains.annotations.NotNull;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericDoorPainted<T extends BlockLogic>
extends BlockModelGenericDoor<T> {
    @NotNull
    public final StaticBlockModel[] left = new StaticBlockModel[16];
    @NotNull
    public final StaticBlockModel[] left_open = new StaticBlockModel[16];
    @NotNull
    public final StaticBlockModel[] right = new StaticBlockModel[16];
    @NotNull
    public final StaticBlockModel[] right_open = new StaticBlockModel[16];

    public BlockModelGenericDoorPainted(@NotNull Block<T> block, boolean bottom) {
        super(block, "minecraft:block/door/planks/white", bottom);
        String side = bottom ? "bottom" : "top";
        for (DyeColor color : DyeColor.blockOrderedColors()) {
            this.left[color.blockMeta] = BlockModelDispatcher.loadDataModel("minecraft:block/door/planks/%s/%s_left".formatted(color.colorID, side)).asModel();
            this.left_open[color.blockMeta] = BlockModelDispatcher.loadDataModel("minecraft:block/door/planks/%s/%s_left_open".formatted(color.colorID, side)).asModel();
            this.right[color.blockMeta] = BlockModelDispatcher.loadDataModel("minecraft:block/door/planks/%s/%s_right".formatted(color.colorID, side)).asModel();
            this.right_open[color.blockMeta] = BlockModelDispatcher.loadDataModel("minecraft:block/door/planks/%s/%s_right_open".formatted(color.colorID, side)).asModel();
        }
    }

    @Override
    @NotNull
    public StaticBlockModel getModelFromData(int data) {
        boolean isOpen;
        int color = data >> 4 & 0xF;
        boolean isLeft = (data & 8) != 0;
        boolean bl = isOpen = (data & 4) != 0;
        if (isLeft) {
            return isOpen ? this.left_open[color] : this.left[color];
        }
        return isOpen ? this.right[color] : this.right_open[color];
    }
}

