/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGenericFenceGate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.DyeColor;
import org.jetbrains.annotations.NotNull;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericFenceGatePainted<T extends BlockLogic>
extends BlockModelGenericFenceGate<T> {
    @NotNull
    public StaticBlockModel[] open = new StaticBlockModel[16];
    @NotNull
    public StaticBlockModel[] closed = new StaticBlockModel[16];

    public BlockModelGenericFenceGatePainted(@NotNull Block<T> block) {
        super(block, "minecraft:block/fencegate/white");
        for (DyeColor color : DyeColor.blockOrderedColors()) {
            this.closed[color.blockMeta] = BlockModelDispatcher.loadDataModel(String.format("minecraft:block/fencegate/%s_closed", color.colorID)).asModel();
            this.open[color.blockMeta] = BlockModelDispatcher.loadDataModel(String.format("minecraft:block/fencegate/%s_open", color.colorID)).asModel();
        }
    }

    @Override
    @NotNull
    public StaticBlockModel getModelFromData(int data) {
        int color = data >> 4 & 0xF;
        boolean open = (data & 4) != 0;
        return open ? this.open[color] : this.closed[color];
    }
}

