/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.dynamictexture;

import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.enums.TextureAnimation;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import org.jetbrains.annotations.NotNull;

public abstract class DynamicTexture {
    @NotNull
    public final IconCoordinate targetTexture;
    public byte[] imageData;

    public DynamicTexture(@NotNull IconCoordinate targetTexture) {
        this.targetTexture = targetTexture;
    }

    public abstract void postInit();

    public abstract void update();

    public boolean runUpdates(boolean isPaused) {
        return GameSettings.TEXTURE_ANIMATIONS.value != TextureAnimation.OFF && !isPaused;
    }

    public void initTexture() {
        this.imageData = new byte[this.targetTexture.width * this.targetTexture.height * 4];
    }

    public static int pmod(int a, int b) {
        while (a < 0) {
            a += b;
        }
        return a % b;
    }

    public static void putPixel(byte[] array, int i, int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        int a = color >> 24 & 0xFF;
        array[i * 4] = (byte)r;
        array[i * 4 + 1] = (byte)g;
        array[i * 4 + 2] = (byte)b;
        array[i * 4 + 3] = (byte)a;
    }
}

