/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.world.chunk.provider;

import net.minecraft.core.world.ProgressListener;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.DisplayChunk;
import net.minecraft.core.world.chunk.EmptyChunk;
import net.minecraft.core.world.chunk.provider.ChunkProvider;
import net.minecraft.core.world.pos.ChunkPosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkProviderViewer
implements ChunkProvider {
    @NotNull
    public final Chunk blankChunk;
    @NotNull
    public final Chunk displayChunk;

    public ChunkProviderViewer(World world) {
        this.blankChunk = new EmptyChunk(world, 0, 0);
        this.displayChunk = new DisplayChunk(world, 0, 0);
    }

    @Override
    public boolean isChunkLoaded(@NotNull ChunkPosc chunkPos) {
        return true;
    }

    @Override
    @NotNull
    public Chunk provideChunk(@NotNull ChunkPosc chunkPos, boolean priority) {
        if (chunkPos.x() == 0 && chunkPos.z() == 0) {
            return this.displayChunk;
        }
        return this.blankChunk;
    }

    @Override
    @NotNull
    public Chunk prepareChunk(@NotNull ChunkPosc chunkPos, boolean priority) {
        if (chunkPos.x() == 0 && chunkPos.z() == 0) {
            return this.displayChunk;
        }
        return this.blankChunk;
    }

    @Override
    public void regenerateChunk(@NotNull ChunkPosc chunkPos) {
    }

    @Override
    public void populate(@NotNull ChunkPosc chunkPos) {
    }

    @Override
    public boolean saveChunks(boolean saveImmediately, @Nullable ProgressListener progressListener) {
        return false;
    }

    @Override
    public boolean tick() {
        return false;
    }

    @Override
    public boolean canSave() {
        return false;
    }

    @Override
    @NotNull
    public String getInfoString() {
        return "";
    }

    @Override
    public void unloadAllChunks() {
    }

    @Override
    public void setCurrentChunkOver(@NotNull ChunkPosc chunkPos) {
    }
}

