/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk.debug;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.ChunkDecorator;
import org.jetbrains.annotations.NotNull;

public class ChunkDecoratorDebug
implements ChunkDecorator {
    @Override
    public void decorate(@NotNull Chunk chunk) {
        int chunkX = chunk.pos.x;
        int chunkZ = chunk.pos.z;
        int chunkBlockOffset = chunkX * 8;
        int chunkMetaOffset = chunkZ * 8;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int blockBlockOffset = x / 2;
                int blockMetaOffset = z / 2;
                if (x % 2 != 0 || z % 2 != 0) continue;
                int blockId = chunkBlockOffset + blockBlockOffset;
                int meta = chunkMetaOffset + blockMetaOffset;
                if (blockId < 0 || blockId >= Blocks.blocksList.length || Blocks.blocksList[blockId] == null) continue;
                chunk.setBlockIDWithMetadata(x, 0, z, blockId, meta);
            }
        }
    }
}

