/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.enums.LeavesQuality;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGeneric;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericLeaves<T extends BlockLogic>
extends BlockModelGeneric<T> {
    @NotNull
    public StaticBlockModel fast;
    @NotNull
    public StaticBlockModel smart;

    public BlockModelGenericLeaves(@NotNull Block<T> block, @NotNull String key) {
        super(block, BlockModelDispatcher.loadDataModel(key + "_fancy"));
        this.fast = BlockModelDispatcher.loadDataModel(key + "_fast").asModel();
        this.smart = BlockModelDispatcher.loadDataModel(key + "_smart").asModel();
    }

    @Override
    @NotNull
    public StaticBlockModel getModelFromData(int data) {
        return switch ((LeavesQuality)((Object)GameSettings.LEAVES_QUALITY.value)) {
            default -> throw new IncompatibleClassChangeError();
            case LeavesQuality.FANCY, LeavesQuality.SMART -> this.staticModel;
            case LeavesQuality.FAST -> this.fast;
        };
    }

    @Override
    @NotNull
    public StaticBlockModel getModel(@NotNull WorldSource source, @NotNull TilePosc tilePosc) {
        return switch ((LeavesQuality)((Object)GameSettings.LEAVES_QUALITY.value)) {
            default -> throw new IncompatibleClassChangeError();
            case LeavesQuality.FANCY -> this.staticModel;
            case LeavesQuality.SMART -> this.smart;
            case LeavesQuality.FAST -> this.fast;
        };
    }

    @Override
    public boolean cullSide(@NotNull WorldSource worldSource, @NotNull TilePosc blockPos, @Nullable Direction direction) {
        if (GameSettings.LEAVES_QUALITY.value == LeavesQuality.FANCY) {
            return super.cullSide(worldSource, blockPos, direction);
        }
        if (direction != null) {
            TilePos shifted = blockPos.add(direction, new TilePos());
            return worldSource.getBlockType(shifted) == this.block || worldSource.isBlockOpaqueCube(shifted);
        }
        return false;
    }
}

